package cn.com.duiba.tuia.pangea.center.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.dto.apollo.ApolloKeyValueAndListDTO;
import cn.com.duiba.tuia.pangea.center.api.dto.apollo.ApolloKeyValueDTO;
import cn.com.duiba.tuia.pangea.center.api.req.apollo.ApolloKeyValueReq;
import cn.com.duiba.tuia.pangea.center.api.rsp.MangoDmpRsp;

/**
 * 阿波罗盘古key-value
 *
 * @author wangzhanjin
 * @email
 * @date 2020-07-21 14:46:33
 */
@AdvancedFeignClient
public interface RemoteApolloKeyValueService {


    /**
     * 【配置新增】接口
     * <p>
     * 1. 插入当前配置
     * 2. 插入从表列表数据（广告位id列表）
     *
     * @param valueAndListDTO
     * @return
     */
    int insertApolloKeyValue(ApolloKeyValueAndListDTO valueAndListDTO);

    /**
     * 【配置修改】接口，修改apollo配置：事务
     * <p>
     * 1. 查询当前配置，入库到历史表
     * 2. 修改当前配置
     * 3. 删除从表列表数据
     * 4. 插入从表列表数据（广告位id列表）
     *
     * @param valueAndListDTO
     * @return
     */
    int updateNotNullApolloKeyValueById(ApolloKeyValueAndListDTO valueAndListDTO);


    /**
     * 查询单个结果
     *
     * @return
     */
    ApolloKeyValueDTO selectApolloKeyValue(ApolloKeyValueDTO dto);

    /**
     * 分页查询
     *
     * @param req
     * @return
     */
    PageResultDto<ApolloKeyValueDTO> selectApolloKeyValueList(ApolloKeyValueReq req);

    /**
     * 阿波罗配置的开启/关闭接口
     * @param dto 修改配置对象
     * @return
     */
    int changeApolloSwitch(ApolloKeyValueDTO dto);

    /**
     * 获取芒果北斗DMP的盘古apollo配置
     * @return
     */
    MangoDmpRsp getMangoDmpConfig();

    /**
     * 删除配置，逻辑删除
     * @param dto
     * @return
     */
    int removeById(ApolloKeyValueDTO dto);
}
