package cn.com.duiba.tuia.pangea.center.api.req.resource;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 广告位活动的资源测试组列表查询
 * @author miaohongshuai
*/
@Data
public class ResourceFlowTestListReq implements Serializable {

    private static final long serialVersionUID = -4234822794062209153L;
    /**
     * 搜索的媒体ID
     */
    private Long appId;
    /**
     * 搜索的媒体名称
     */
    private String appName;
    /**
     * 搜索的广告位ID
     */
    private Long slotId;
    /**
     * 搜索的广告位名称
     */
    private String slotName;
    /**
     * 搜索的活动ID
     */
    private Long activityId;
    /**
     * 测试计划ID
     */
    private Long planId;
    /**
     * 分流活动ID列表
     */
    private List<Long> activityIds;
    /**
     * 分流广告位ID列表
     */
    private List<Long> slotIds;
    /**
     * 测试类型，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
     */
    private Integer testType;
    /**
     * "asc" ：升序，"desc"：降序
     */
    private String order;
}
