/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AccessOrderDeque;
import com.github.benmanes.caffeine.cache.WriteOrderDeque;
import java.lang.ref.ReferenceQueue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

interface Node<K, V>
extends AccessOrderDeque.AccessOrder<Node<K, V>>,
WriteOrderDeque.WriteOrder<Node<K, V>> {
    public static final int EDEN = 0;
    public static final int PROBATION = 1;
    public static final int PROTECTED = 2;

    @Nullable
    public K getKey();

    @Nonnull
    public Object getKeyReference();

    @Nullable
    public V getValue();

    @Nonnull
    public Object getValueReference();

    @GuardedBy(value="this")
    public void setValue(@Nonnull V var1, @Nullable ReferenceQueue<V> var2);

    public boolean containsValue(@Nonnull Object var1);

    @Nonnegative
    @GuardedBy(value="this")
    default public int getWeight() {
        return 1;
    }

    @Nonnegative
    @GuardedBy(value="this")
    default public void setWeight(int weight) {
    }

    @Nonnegative
    @GuardedBy(value="evictionLock")
    default public int getPolicyWeight() {
        return 1;
    }

    @Nonnegative
    @GuardedBy(value="evictionLock")
    default public void setPolicyWeight(int weight) {
    }

    @GuardedBy(value="this")
    public boolean isAlive();

    @GuardedBy(value="this")
    public boolean isRetired();

    @GuardedBy(value="this")
    public boolean isDead();

    @GuardedBy(value="this")
    public void retire();

    @GuardedBy(value="this")
    public void die();

    default public boolean inEden() {
        return this.getQueueType() == 0;
    }

    default public boolean inMainProbation() {
        return this.getQueueType() == 1;
    }

    default public boolean inMainProtected() {
        return this.getQueueType() == 2;
    }

    default public void makeMainProbation() {
        this.setQueueType(1);
    }

    default public void makeMainProtected() {
        this.setQueueType(2);
    }

    default public int getQueueType() {
        return 0;
    }

    default public void setQueueType(int queueType) {
        throw new UnsupportedOperationException();
    }

    default public long getAccessTime() {
        return 0L;
    }

    default public void setAccessTime(long time) {
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public Node<K, V> getPreviousInAccessOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public void setPreviousInAccessOrder(@Nullable Node<K, V> prev) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public Node<K, V> getNextInAccessOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public void setNextInAccessOrder(@Nullable Node<K, V> next) {
        throw new UnsupportedOperationException();
    }

    default public long getWriteTime() {
        return 0L;
    }

    default public void setWriteTime(long time) {
    }

    default public boolean casWriteTime(long expect, long update) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public Node<K, V> getPreviousInWriteOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public void setPreviousInWriteOrder(@Nullable Node<K, V> prev) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public Node<K, V> getNextInWriteOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public void setNextInWriteOrder(@Nullable Node<K, V> next) {
        throw new UnsupportedOperationException();
    }
}

