/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.redis;

import cn.com.duiba.wolf.utils.NumberUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.Pool;
import redis.clients.util.Slowlog;

public class RedisClient
implements JedisCommands,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(RedisClient.class);
    private static final int DEFAULT_CONN_OR_SO_TIMEOUT = 1000;
    private Pool<Jedis> jedisPool;
    private Thread monitorThread;
    private Integer maxPoolSize;
    private Integer warnPoolSize;

    public RedisClient(boolean isUseSentinel, String sentinelMasterName, String servers, String password) {
        this.init(isUseSentinel, sentinelMasterName, servers, password, 1000, this.getDefaultConfig());
    }

    public RedisClient(boolean isUseSentinel, String sentinelMasterName, String servers, String password, int connOrSoTimeout) {
        this.init(isUseSentinel, sentinelMasterName, servers, password, connOrSoTimeout, this.getDefaultConfig());
    }

    public RedisClient(boolean isUseSentinel, String sentinelMasterName, String servers, String password, int connOrSoTimeout, Integer maxPoolSize) {
        JedisPoolConfig config = this.getDefaultConfig();
        config.setMaxTotal(maxPoolSize.intValue());
        config.setMaxIdle(maxPoolSize.intValue());
        if (config.getMinIdle() > maxPoolSize) {
            config.setMinIdle(maxPoolSize.intValue());
        }
        this.init(isUseSentinel, sentinelMasterName, servers, password, connOrSoTimeout, config);
    }

    public RedisClient(boolean isUseSentinel, String sentinelMasterName, String servers, String password, int connOrSoTimeout, JedisPoolConfig config) {
        this.init(isUseSentinel, sentinelMasterName, servers, password, connOrSoTimeout, config);
    }

    private void init(boolean isUseSentinel, String sentinelMasterName, String servers, String password, int connOrSoTimeout, JedisPoolConfig config) {
        String[] serverArr = servers.split(",");
        ArrayList<String> serverList = new ArrayList<String>();
        for (String s : serverArr) {
            if (StringUtils.isBlank((String)s)) continue;
            serverList.add(s);
        }
        if (isUseSentinel) {
            this.jedisPool = new JedisSentinelPool(sentinelMasterName, new HashSet(serverList), (GenericObjectPoolConfig)config, connOrSoTimeout, password);
        } else {
            if (serverList.size() != 1) {
                throw new IllegalArgumentException("when not using sentinel, [servers] must contains one and only one node.");
            }
            String[] serverConfig = ((String)serverList.get(0)).split(":");
            String host = serverConfig[0];
            int port = NumberUtils.parseInt(serverConfig[1], 0);
            this.maxPoolSize = config.getMaxTotal();
            this.warnPoolSize = this.maxPoolSize / 2;
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)config, host, port, connOrSoTimeout, password);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.monitorThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (Thread.currentThread().isInterrupted()) break;
                    int numActive = RedisClient.this.jedisPool.getNumActive();
                    int numIdle = RedisClient.this.jedisPool.getNumIdle();
                    int numWaiters = RedisClient.this.jedisPool.getNumWaiters();
                    if (numActive <= RedisClient.this.warnPoolSize && numWaiters <= 1) continue;
                    logger.warn("redis \u544a\u8b66,maxTotal:{},numActive:{},numIdle:{},numWaiters:{}", new Object[]{RedisClient.this.maxPoolSize, numActive, numIdle, numWaiters});
                }
            }
        };
        this.monitorThread.start();
    }

    public void destroy() throws Exception {
        this.monitorThread.interrupt();
    }

    private JedisPoolConfig getDefaultConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMinIdle(5);
        config.setTestOnBorrow(false);
        config.setMaxTotal(60);
        config.setMaxIdle(config.getMaxTotal());
        config.setMaxWaitMillis(200L);
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(90000L);
        return config;
    }

    private Jedis getResource() {
        return (Jedis)this.jedisPool.getResource();
    }

    public void close() {
        this.jedisPool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.set(key, value);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value, String nxxx, String expx, long time) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.set(key, value, nxxx, expx, time);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value, String nxxx) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.set(key, value, nxxx);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        long start = System.currentTimeMillis();
        Jedis jedis = this.getResource();
        try {
            String string = jedis.get(key);
            return string;
        }
        finally {
            jedis.close();
            long period = System.currentTimeMillis() - start;
            if (period > 50L) {
                logger.warn("redis.get cost {} ms, too long,key is:{}", (Object)period, (Object)key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(String key) {
        try (Jedis jedis = this.getResource();){
            Boolean bl = jedis.exists(key);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long persist(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.persist(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String type(String key) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.type(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(String key, int seconds) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.expire(key, seconds);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pexpire(String key, long milliseconds) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.pexpire(key, milliseconds);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expireAt(String key, long unixTime) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.expireAt(key, unixTime);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pexpireAt(String key, long millisecondsTimestamp) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.pexpireAt(key, millisecondsTimestamp);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long ttl(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.ttl(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pttl(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.pttl(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean setbit(String key, long offset, boolean value) {
        try (Jedis jedis = this.getResource();){
            Boolean bl = jedis.setbit(key, offset, value);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean setbit(String key, long offset, String value) {
        try (Jedis jedis = this.getResource();){
            Boolean bl = jedis.setbit(key, offset, value);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getbit(String key, long offset) {
        try (Jedis jedis = this.getResource();){
            Boolean bl = jedis.getbit(key, offset);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setrange(String key, long offset, String value) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.setrange(key, offset, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getrange(String key, long startOffset, long endOffset) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.getrange(key, startOffset, endOffset);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSet(String key, String value) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.getSet(key, value);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(String key, String value) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.setnx(key, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(String key, int seconds, String value) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.setex(key, seconds, value);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String psetex(String key, long milliseconds, String value) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.psetex(key, milliseconds, value);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long decrBy(String key, long integer) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.decrBy(key, integer);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long decr(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.decr(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incrBy(String key, long integer) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.incrBy(key, integer);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double incrByFloat(String key, double value) {
        try (Jedis jedis = this.getResource();){
            Double d = jedis.incrByFloat(key, value);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incr(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.incr(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long append(String key, String value) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.append(key, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String substr(String key, int start, int end) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.substr(key, start, end);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(String key, String field, String value) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.hset(key, field, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.hget(key, field);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hsetnx(String key, String field, String value) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.hsetnx(key, field, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(String key, Map<String, String> hash) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.hmset(key, hash);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hmget(String key, String ... fields) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.hmget(key, fields);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hincrBy(String key, String field, long value) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.hincrBy(key, field, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double hincrByFloat(String key, String field, double value) {
        try (Jedis jedis = this.getResource();){
            Double d = jedis.hincrByFloat(key, field, value);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hexists(String key, String field) {
        try (Jedis jedis = this.getResource();){
            Boolean bl = jedis.hexists(key, field);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(String key, String ... field) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.hdel(key, field);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hlen(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.hlen(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> hkeys(String key) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.hkeys(key);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hvals(String key) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.hvals(key);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hgetAll(String key) {
        try (Jedis jedis = this.getResource();){
            Map map = jedis.hgetAll(key);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpush(String key, String ... string) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.rpush(key, string);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(String key, String ... string) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.lpush(key, string);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long llen(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.llen(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> lrange(String key, long start, long end) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.lrange(key, start, end);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ltrim(String key, long start, long end) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.ltrim(key, start, end);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lindex(String key, long index) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.lindex(key, index);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lset(String key, long index, String value) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.lset(key, index, value);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lrem(String key, long count, String value) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.lrem(key, count, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lpop(String key) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.lpop(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rpop(String key) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.rpop(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sadd(String key, String ... member) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.sadd(key, member);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(String key) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.smembers(key);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(String key, String ... member) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.srem(key, member);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String spop(String key) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.spop(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> spop(String key, long count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.spop(key, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long scard(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.scard(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean sismember(String key, String member) {
        try (Jedis jedis = this.getResource();){
            Boolean bl = jedis.sismember(key, member);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String srandmember(String key) {
        try (Jedis jedis = this.getResource();){
            String string = jedis.srandmember(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> srandmember(String key, int count) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.srandmember(key, count);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long strlen(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.strlen(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, double score, String member) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zadd(key, score, member);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, double score, String member, ZAddParams params) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zadd(key, score, member, params);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zadd(key, scoreMembers);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zadd(key, scoreMembers, params);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrange(String key, long start, long end) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrange(key, start, end);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrem(String key, String ... member) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zrem(key, member);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zincrby(String key, double score, String member) {
        try (Jedis jedis = this.getResource();){
            Double d = jedis.zincrby(key, score, member);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        try (Jedis jedis = this.getResource();){
            Double d = jedis.zincrby(key, score, member, params);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrank(String key, String member) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zrank(key, member);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrevrank(String key, String member) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zrevrank(key, member);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrange(String key, long start, long end) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrange(key, start, end);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeWithScores(key, start, end);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeWithScores(key, start, end);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcard(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zcard(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zscore(String key, String member) {
        try (Jedis jedis = this.getResource();){
            Double d = jedis.zscore(key, member);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sort(String key) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.sort(key);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sort(String key, SortingParams sortingParameters) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.sort(key, sortingParameters);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcount(String key, double min, double max) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zcount(key, min, max);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcount(String key, String min, String max) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zcount(key, min, max);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByScore(String key, double min, double max) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByScore(String key, String min, String max) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByScore(String key, double max, double min) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByScore(key, max, min);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByScore(String key, String max, String min) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByScore(key, max, min);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zremrangeByRank(String key, long start, long end) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zremrangeByRank(key, start, end);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zremrangeByScore(String key, double start, double end) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zremrangeByScore(key, start, end);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zremrangeByScore(String key, String start, String end) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zremrangeByScore(key, start, end);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zlexcount(String key, String min, String max) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zlexcount(key, min, max);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByLex(String key, String min, String max) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByLex(key, min, max);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrangeByLex(key, min, max, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByLex(String key, String max, String min) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByLex(key, max, min);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        try (Jedis jedis = this.getResource();){
            Set set = jedis.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zremrangeByLex(String key, String min, String max) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.zremrangeByLex(key, min, max);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.linsert(key, where, pivot, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpushx(String key, String ... string) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.lpushx(key, string);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpushx(String key, String ... string) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.rpushx(key, string);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<String> blpop(String arg) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.blpop(arg);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> blpop(int timeout, String key) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.blpop(timeout, key);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<String> brpop(String arg) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.brpop(arg);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> brpop(int timeout, String key) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.brpop(timeout, key);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.del(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String ... keys) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.del(keys);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String echo(String string) {
        try (Jedis jedis = this.getResource();){
            String string2 = jedis.echo(string);
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long move(String key, int dbIndex) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.move(key, dbIndex);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long bitcount(String key) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.bitcount(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long bitcount(String key, long start, long end) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.bitcount(key, start, end);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long bitpos(String key, boolean value) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.bitpos(key, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long bitpos(String key, boolean value, BitPosParams params) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.bitpos(key, value, params);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> scan(String cursor) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.scan(cursor);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> scan(String cursor, ScanParams scanParams) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.scan(cursor, scanParams);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.hscan(key, cursor);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ScanResult<String> sscan(String key, int cursor) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.sscan(key, cursor);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ScanResult<Tuple> zscan(String key, int cursor) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.zscan(key, cursor);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.hscan(key, cursor);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.hscan(key, cursor, params);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> sscan(String key, String cursor) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.sscan(key, cursor);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.sscan(key, cursor, params);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Tuple> zscan(String key, String cursor) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.zscan(key, cursor);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        try (Jedis jedis = this.getResource();){
            ScanResult scanResult = jedis.zscan(key, cursor, params);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pfadd(String key, String ... elements) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.pfadd(key, elements);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pfcount(String key) {
        try (Jedis jedis = this.getResource();){
            long l = jedis.pfcount(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long geoadd(String key, double longitude, double latitude, String member) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.geoadd(key, longitude, latitude, member);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.geoadd(key, memberCoordinateMap);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double geodist(String key, String member1, String member2) {
        try (Jedis jedis = this.getResource();){
            Double d = jedis.geodist(key, member1, member2);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        try (Jedis jedis = this.getResource();){
            Double d = jedis.geodist(key, member1, member2, unit);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> geohash(String key, String ... members) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.geohash(key, members);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoCoordinate> geopos(String key, String ... members) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.geopos(key, members);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.georadius(key, longitude, latitude, radius, unit);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.georadius(key, longitude, latitude, radius, unit, param);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.georadiusByMember(key, member, radius, unit);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.georadiusByMember(key, member, radius, unit, param);
            return list;
        }
    }

    public List<Long> bitfield(String key, String ... arguments) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.bitfield(key, arguments);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long publish(String channel, String message) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.publish(channel, message);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long publish(byte[] channel, byte[] message) {
        try (Jedis jedis = this.getResource();){
            Long l = jedis.publish(channel, message);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        try (Jedis jedis = this.getResource();){
            jedis.subscribe(jedisPubSub, channels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        try (Jedis jedis = this.getResource();){
            jedis.subscribe(jedisPubSub, channels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        try (Jedis jedis = this.getResource();){
            jedis.psubscribe(jedisPubSub, patterns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        try (Jedis jedis = this.getResource();){
            jedis.psubscribe(jedisPubSub, patterns);
        }
    }

    public void eval(String script) {
        try (Jedis jedis = this.getResource();){
            jedis.eval(script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(String script, int keyCount, String ... params) {
        try (Jedis jedis = this.getResource();){
            jedis.eval(script, keyCount, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(String script, List<String> keys, List<String> args) {
        try (Jedis jedis = this.getResource();){
            jedis.eval(script, keys, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Slowlog> slowlogGet(long entries) {
        try (Jedis jedis = this.getResource();){
            List list = jedis.slowlogGet(entries);
            return list;
        }
    }
}

