package cn.com.duiba.tuia.pangea.center.api.rsp.resource;

import cn.com.duiba.tuia.pangea.center.api.dto.resource.TestResourceFlowDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 用于编辑或追加投放的测试计划配置数据返回
 * @author miaohongshuai
*/
@Data
public class ResourceFlowTestSelectForUpdateRsp implements Serializable {

    private static final long serialVersionUID = 7659356500906885151L;

    @ApiModelProperty(value = "测试计划名称", required = true, dataType = "string")
    private String planName;

    @ApiModelProperty(value = "测试计划ID")
    private Long planId;

    @ApiModelProperty(value = "测试计划开始时间", required = true)
    private Date startTime;

    @ApiModelProperty(value = "测试计划结束时间", required = true)
    private Date endTime;

    @ApiModelProperty(value = "流量选择类型", required = true)
    private Integer flowType;

    @ApiModelProperty(value = "测试人", required = true)
    private String testName;

    @ApiModelProperty(value = "测试人adminId")
    private Long adminId;

    @ApiModelProperty(value = "测试挑选的广告位列表")
    private Set<String> slotKey;

    @ApiModelProperty(value = "测试挑选的活动列表")
    private List<Long> controlGroup;

    @ApiModelProperty(value = "已选广告位个数")
    private Integer slotNum;

    @ApiModelProperty(value = "活动测试访问UV")
    private Long uv;

    @ApiModelProperty(value = "测试组配置")
    private List<TestResourceFlowDTO> testGroupList;
}
