/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.collect.Lists;
import java.util.List;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.VendorExtension;

public class ModelPropertyBuilder {
    private ResolvedType type;
    private String qualifiedType;
    private int position;
    private Boolean required;
    private Boolean readOnly;
    private String description;
    private AllowableValues allowableValues;
    private String name;
    private boolean isHidden;
    private String example;
    private String pattern;
    private List<VendorExtension> vendorExtensions = Lists.newArrayList();

    public ModelPropertyBuilder name(String name) {
        this.name = BuilderDefaults.defaultIfAbsent(name, this.name);
        return this;
    }

    public ModelPropertyBuilder type(ResolvedType type) {
        this.type = BuilderDefaults.replaceIfMoreSpecific(type, this.type);
        return this;
    }

    public ModelPropertyBuilder qualifiedType(String qualifiedType) {
        this.qualifiedType = BuilderDefaults.defaultIfAbsent(qualifiedType, this.qualifiedType);
        return this;
    }

    public ModelPropertyBuilder position(int position) {
        this.position = position;
        return this;
    }

    public ModelPropertyBuilder required(Boolean required) {
        this.required = required;
        return this;
    }

    public ModelPropertyBuilder readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ModelPropertyBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(description, this.description);
        return this;
    }

    public ModelPropertyBuilder example(String example) {
        this.example = BuilderDefaults.defaultIfAbsent(example, this.example);
        return this;
    }

    public ModelPropertyBuilder allowableValues(AllowableValues allowableValues) {
        this.allowableValues = BuilderDefaults.emptyToNull(allowableValues, this.allowableValues);
        return this;
    }

    public ModelPropertyBuilder isHidden(Boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    public ModelPropertyBuilder pattern(String pattern) {
        this.pattern = BuilderDefaults.defaultIfAbsent(pattern, this.pattern);
        return this;
    }

    public ModelPropertyBuilder extensions(List<VendorExtension> extensions) {
        this.vendorExtensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public ModelProperty build() {
        return new ModelProperty(this.name, this.type, this.qualifiedType, this.position, this.required, this.isHidden, this.readOnly, this.description, this.allowableValues, this.example, this.pattern, this.vendorExtensions);
    }
}

