package cn.com.duiba.tuia.purchase.web.api.model.query.financial;

import cn.com.duiba.tuia.purchase.web.api.model.query.BaseQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author ikongyi && zhongda
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FinancialDailyRecordQuery extends BaseQuery {

    private static final long serialVersionUID = 7754583032898056720L;
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private Date startDate;
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private Date endDate;
    private Long advertiserId;
    private Long mediaAppId;
    private Long productId;
    private Integer chargeType;
    /**
     * 数据有效状态：
     * <code>{@link cn.com.duiba.tuia.purchase.web.api.constant.ValidStatus#YES}</code> 有效
     * <code>{@link cn.com.duiba.tuia.purchase.web.api.constant.ValidStatus#NO}</code> 无效
     */
    private Integer validStatus;
    private Long mediaConfigId;
}
