/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.purchase.web.api.localservice;

import cn.com.duiba.tuia.purchase.web.api.dto.PbpMediaCallbackStrategyDto;
import cn.com.duiba.tuia.purchase.web.api.dto.PbpMediaPlatformDto;
import cn.com.duiba.tuia.purchase.web.api.dto.PbpProductDto;
import cn.com.duiba.tuia.purchase.web.api.dto.PbpTaskDto;
import cn.com.duiba.tuia.purchase.web.api.dto.PutPlanDto;
import cn.com.duiba.tuia.purchase.web.api.model.PbpEventCallbackStrategyContext;
import cn.com.duiba.tuia.purchase.web.api.remoteservice.RemotePurchaseService;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OcpcPurchaseService {
    private static final Logger log = LoggerFactory.getLogger(OcpcPurchaseService.class);
    @Resource
    private RemotePurchaseService remotePurchaseService;
    private final LoadingCache<Long, Optional<PutPlanDto>> planCaffeineCache = Caffeine.newBuilder().maximumSize(4000L).initialCapacity(20).refreshAfterWrite(30L, TimeUnit.SECONDS).expireAfterWrite(300L, TimeUnit.SECONDS).build(this::queryByChannelId);
    private final LoadingCache<Long, Optional<PbpTaskDto>> taskCaffeineCache = Caffeine.newBuilder().maximumSize(4000L).initialCapacity(20).refreshAfterWrite(30L, TimeUnit.SECONDS).expireAfterWrite(300L, TimeUnit.SECONDS).build(this::queryByTaskId);
    private final LoadingCache<Long, Optional<PbpProductDto>> productCaffeineCache = Caffeine.newBuilder().maximumSize(1000L).initialCapacity(10).refreshAfterWrite(30L, TimeUnit.SECONDS).expireAfterWrite(300L, TimeUnit.SECONDS).build(this::queryByProductId);
    private final LoadingCache<Long, Optional<PbpMediaPlatformDto>> mediaPlatformCaffeineCache = Caffeine.newBuilder().maximumSize(200L).initialCapacity(10).refreshAfterWrite(1800L, TimeUnit.SECONDS).expireAfterWrite(7200L, TimeUnit.SECONDS).build(this::queryByMediaPlatformId);

    public Optional<PutPlanDto> getByChannelId(Long channelId) {
        return (Optional)this.planCaffeineCache.get((Object)channelId);
    }

    public Optional<PbpProductDto> getProductByTaskId(Long taskId) {
        Optional<PbpTaskDto> pbpTaskDto = this.getTaskById(taskId);
        if (!pbpTaskDto.isPresent()) {
            return Optional.empty();
        }
        Long productId = pbpTaskDto.get().getProductId();
        return this.getByProductId(productId);
    }

    public Optional<PbpProductDto> getByProductId(Long productId) {
        return (Optional)this.productCaffeineCache.get((Object)productId);
    }

    public Optional<PbpTaskDto> getTaskById(Long taskId) {
        return (Optional)this.taskCaffeineCache.get((Object)taskId);
    }

    public Optional<PbpMediaPlatformDto> getByMediaPlatformId(Long mediaPlatformId) {
        return (Optional)this.mediaPlatformCaffeineCache.get((Object)mediaPlatformId);
    }

    public String getEventType(Long channelId, String eventType) {
        Optional<PutPlanDto> optional = this.getByChannelId(channelId);
        if (!optional.isPresent()) {
            log.info("not found channelId {}", (Object)channelId);
            return null;
        }
        PutPlanDto putPlan = optional.get();
        Long putPlanId = putPlan.getId();
        if (!putPlan.getIsCallBack().booleanValue()) {
            log.info("the callback configuration is not enabled\uff1achannelId is {}\uff0cplanId is {}\uff0ceventType is {}", new Object[]{channelId, putPlanId, eventType});
            return null;
        }
        Map actionIdMap = (Map)ObjectUtils.defaultIfNull(putPlan.getActionIdMap(), Collections.emptyMap());
        if (!actionIdMap.containsKey(eventType)) {
            log.info("tuia event type not supported\uff1achannelId is {}\uff0cplanId is {}\uff0ceventType is {}", new Object[]{channelId, putPlanId, eventType});
            return null;
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)actionIdMap.get(eventType)))) {
            log.info("media event type is not defined\uff1achannelId is {}\uff0cplanId is {}\uff0ceventType is {}", new Object[]{channelId, putPlanId, eventType});
            return null;
        }
        int randomNumber = RandomUtils.nextInt((int)0, (int)10000);
        if (randomNumber >= putPlan.getProbabilityBack()) {
            log.info("\u6982\u7387\u56de\u4f20\u672a\u547d\u4e2d\uff1achannelId is {}\uff0cplanId is {}\uff0ceventType is {}\uff0cPR is {}, randomNumber is {}", new Object[]{channelId, putPlanId, eventType, putPlan.getProbabilityBack(), randomNumber});
            return null;
        }
        return (String)actionIdMap.get(eventType);
    }

    public PbpEventCallbackStrategyContext getEventCallbackStrategyContext(Long channelId, String aEventType) {
        PbpEventCallbackStrategyContext context = new PbpEventCallbackStrategyContext();
        context.setChannelId(channelId);
        context.setAEventType(aEventType);
        context.setShouldCallback(Boolean.FALSE);
        Optional<PutPlanDto> optional = this.getByChannelId(channelId);
        if (!optional.isPresent()) {
            log.info("\u6295\u653e\u8ba1\u5212\u4e0d\u5b58\u5728\uff1achannelId={}", (Object)channelId);
            return context;
        }
        PutPlanDto putPlan = optional.get();
        Long putPlanId = putPlan.getId();
        context.setPlanId(putPlanId);
        if (!putPlan.getIsCallBack().booleanValue()) {
            log.info("\u8be5\u8ba1\u5212\u65e0\u9700\u56de\u4f20\u5a92\u4f53\u6570\u636e\uff1achannelId={}\uff0cplanId={}\uff0caEventType={}", new Object[]{channelId, putPlanId, aEventType});
            return context;
        }
        PbpMediaCallbackStrategyDto mediaCallbackStrategyDto = putPlan.getMediaCallbackStrategyDto();
        List<PbpMediaCallbackStrategyDto.StrategyItem> strategySet = mediaCallbackStrategyDto.getStrategySet();
        PbpMediaCallbackStrategyDto.StrategyItem strategyItem = strategySet.get(0);
        Integer strategyType = strategyItem.getStrategyType();
        List<PbpMediaCallbackStrategyDto.StrategyContent> strategyRules = strategyItem.getStrategyGroup();
        context.setStrategyId(mediaCallbackStrategyDto.getId());
        context.setStrategyType(strategyType);
        for (PbpMediaCallbackStrategyDto.StrategyContent rule : strategyRules) {
            Map eventTypeMap = (Map)ObjectUtils.defaultIfNull(rule.getEventTypeMap(), Collections.emptyMap());
            String mEventType = (String)eventTypeMap.get(aEventType);
            if (!StringUtils.isNotBlank((CharSequence)mEventType)) continue;
            context.setMEventType(mEventType);
            context.setStrategyRule(rule);
            break;
        }
        if (Objects.isNull(context.getStrategyRule())) {
            log.warn("\u8be5\u8ba1\u5212\u5a92\u4f53\u56de\u4f20\u7b56\u7565\u6570\u636e\u5f02\u5e38\uff1achannelId={}\uff0cplanId={}\uff0ccallbackStrategy={}", new Object[]{channelId, putPlanId, JSON.toJSONString((Object)mediaCallbackStrategyDto)});
            return context;
        }
        if (Objects.equals(strategyType, 1)) {
            PbpMediaCallbackStrategyDto.StrategyContent strategyRule = context.getStrategyRule();
            int probVal = strategyRule.getCbProb();
            int randomNumber = RandomUtils.nextInt((int)0, (int)10000);
            if (randomNumber >= probVal) {
                log.info("\u6982\u7387\u56de\u4f20\u672a\u547d\u4e2d\uff1achannelId={}\uff0cplanId={}\uff0caEventType={}\uff0cprobVal={}, randomNum={}", new Object[]{channelId, putPlanId, aEventType, probVal, randomNumber});
                return context;
            }
        } else if (!Objects.equals(strategyType, 2)) {
            throw new RuntimeException("\u672a\u77e5\u7684\u56de\u4f20\u7b56\u7565\u7c7b\u578b" + strategyType);
        }
        context.setShouldCallback(Boolean.TRUE);
        return context;
    }

    private Optional<PutPlanDto> queryByChannelId(Long channelId) {
        PutPlanDto putPlanDto = this.remotePurchaseService.getPlanByChannelId(channelId);
        return Optional.ofNullable(putPlanDto);
    }

    private Optional<PbpProductDto> queryByProductId(Long productId) {
        PbpProductDto pbpProductDto = this.remotePurchaseService.getProductById(productId);
        return Optional.ofNullable(pbpProductDto);
    }

    private Optional<PbpTaskDto> queryByTaskId(Long taskId) {
        PbpTaskDto pbpTaskDto = this.remotePurchaseService.getTaskById(taskId);
        return Optional.ofNullable(pbpTaskDto);
    }

    private Optional<PbpMediaPlatformDto> queryByMediaPlatformId(Long mediaPlatformId) {
        PbpMediaPlatformDto pbpMediaPlatformDto = this.remotePurchaseService.getMediaPlatformById(mediaPlatformId);
        return Optional.ofNullable(pbpMediaPlatformDto);
    }
}

