package cn.com.duiba.tuia.purchase.web.api.model.req;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author ikongyi && zhongda
 */
@Getter
@Setter
public class MediaConfigModifyRequest implements Serializable {

    private static final long serialVersionUID = -7272625344633017371L;

    public static final Integer SHOULD_UPDATE_FINANCIAL_RECORD = 1;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 媒体返点（百分点）
     */
    private BigDecimal rebateRate;

    /**
     * 是否更新历史媒体消耗数据：
     *              <code>1</code>是
     *              <code>0</code>否
     */
    private Integer shouldRecalc;

    /**
     * 运营负责人
     */
    private List<Long> managerIds;

    /**
     * 备注
     */
    private String remark;
}
