package cn.com.duiba.tuia.purchase.web.api.dto;

import cn.com.duiba.tuia.purchase.web.api.constant.DeleteStatus;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author zhongda & ikongyi
 */
@Getter
@Setter
public class PbpMediaCallbackStrategyDto implements Serializable {

    private static final long serialVersionUID = 5922602183859066734L;

    /**
     * 自增主键
     */
    private Long id;

    /**
     * 策略维度类型：1-媒体、2-产品、3-任务、4-计划
     */
    private Integer dimType;

    /**
     * 策略维度类型值，分别对应：媒体ID、产品ID、任务ID、计划ID
     */
    private Long dimValue;

    /**
     * 策略集
     */
    private List<StrategyItem> strategySet;

    /**
     * <pre>
     *     逻辑删除状态：<code>{@link DeleteStatus#UNDELETED}</code> 未删除
     *                <code>{@link DeleteStatus#DELETED}</code> 已删除
     * </pre>
     * @see DeleteStatus
     */
    private Integer deleteStatus;

    /**
     * <pre>
     * 这个字段可以用来满足数据库层面状态唯一性约束需求，比如：同一笔外部流水只能一次成功，允许多次失败这种场景。
     * 唯一约束辅助字段，同一维度下只能有一个生效策略，允许多个无效策略
     *
     * 写入时，业务层设置值会被忽略，内部默认值规则如下：
     * 订单状态：<code>{@link DeleteStatus#UNDELETED}</code>，默认值为{@link DeleteStatus#UNDELETED}
     *         <code>{@link DeleteStatus#DELETED}</code>，默认值为{@link #id}
     * </pre>
     */
    private Long statusUixSeq;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    @Getter
    @Setter
    public static class StrategyItem implements Serializable {
        private static final long serialVersionUID = 3460762184321661054L;
        /**
         * 策略类型：1-概率回传、2-按收益回传
         */
        private Integer strategyType;
        private List<StrategyContent> strategyGroup;
    }

    @Getter
    @Setter
    public static class StrategyContent implements Serializable {
        private static final long serialVersionUID = -547478236262962747L;
        /**
         * 推啊媒体事件类型映射
         */
        private Map<String /* 推啊数据类型 */, String /* 媒体数据类型 */> eventTypeMap;

        /**
         * 回传概率（概率回传时必填）
         * e.g.：6850 -> 68.50%
         */
        private Integer cbProb;

        /**
         * 收益配置，单位：分（按收益回传时必填）
         * e.g.：1050 -> 10.5元
         */
        private Integer amountThreshold;

        /**
         * 维度（按收益回传时必填）：1-计划为度、2-商家维度、3-商品维度
         */
        private Integer dimType;

        /**
         * 回传订单类型（按收益回传时必填）：1-佣金最高、2-商品单价最高
         */
        private Integer priority;
    }
}
