package cn.com.duiba.tuia.purchase.web.api.model.query.callbackstrategy;

import cn.com.duiba.tuia.purchase.web.api.constant.DeleteStatus;
import cn.com.duiba.tuia.purchase.web.api.model.query.BaseQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhongda & ikongyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MediaCallbackStrategyQuery extends BaseQuery {

    private static final long serialVersionUID = 4580824451761890336L;

    /**
     * 策略维度类型：1-媒体、2-产品、3-任务、4-计划
     */
    private Integer dimType;

    /**
     * 策略维度类型值，分别对应：媒体ID、产品ID、任务ID、计划ID
     */
    private Long dimValue;

    /**
     * <pre>
     *     逻辑删除状态：<code>{@link DeleteStatus#UNDELETED}</code> 未删除
     *                <code>{@link DeleteStatus#DELETED}</code> 已删除
     * </pre>
     * @see DeleteStatus
     */
    private Integer deleteStatus;

    /**
     * <pre>
     * 这个字段可以用来满足数据库层面状态唯一性约束需求，比如：同一笔外部流水只能一次成功，允许多次失败这种场景。
     * 唯一约束辅助字段，同一维度下只能有一个生效策略，允许多个无效策略
     *
     * 写入时，业务层设置值会被忽略，内部默认值规则如下：
     * 订单状态：<code>{@link DeleteStatus#UNDELETED}</code>，默认值为{@link DeleteStatus#UNDELETED}
     *         <code>{@link DeleteStatus#DELETED}</code>，默认值为{@link #getId()}
     * </pre>
     */
    private Long statusUixSeq;

}
