package cn.com.duiba.tuia.purchase.web.api.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author lizhiheng
 */
@NoArgsConstructor
@Data
public class MeituanCallbackDataDTO {

    /**
     * 订单标题
     */
    private String smstitle;
    /**
     * 订单数量
     */
    private String quantity;
    /**
     * 订单id
     */
    private String orderid;
    /**
     * 店铺id（部分存在）
     */
    private String dealid;
    /**
     * 订单支付时间，10位时间戳
     */
    private String paytime;
    /**
     * 订单类型，枚举值同订单查询接口定义
     */
    private String type;
    /**
     * 下单时间，10位时间戳
     */
    private String ordertime;
    /**
     * 媒体推广位sid
     */
    private String sid;
    /**
     * 渠道id
     */
    private String uid;
    /**
     * 商品ID
     */
    private String productId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 订单状态，枚举值同订单查询接口返回定义
     */
    private String status;
    /**
     * 订单总金额
     */
    private String total;
    /**
     * 订单实际支付金额
     */
    private String direct;
    /**
     * 订单返佣比例，cps活动的订单会返回该字段
     */
    private String ratio;
    /**
     * 订单签名字段
     */
    private String sign;
    /**
     * 活动id，可以在联盟活动列表中查看获取
     */
    private String actId;
    /**
     * 业务线类型
     */
    private String businessLine;
    /**
     * 子业务线
     */
    private String subBusinessLine;
    /**
     * 媒体名称，可在推广者备案-媒体管理中查询
     */
    private String appkey;
    /**
     * 订单实际支付金额
     */
    private String payPrice;
    /**
     * 订单修改时间
     */
    private String modTime;
    /**
     * 核销类型 0 未核销 1 已核销
     */
    private String consumeType;
    /**
     * 退款类型 否ALL_REFUND(1, "全部退"),PART_REFUND(2, "部分退")，RISK_REFUND(3, "风控")
     */
    private String refundType;
    /**
     * 消费券加密券ID
     */
    private String encryptionVoucherId;
    /**
     * oaidmd5
     */
    private String encryptionDeviceId;
    /**
     * 优选订单类型返回该字段 2 cps 3 首购奖励
     */
    private List<Integer> tradeTypeList;
}
