package cn.com.duiba.tuia.purchase.web.api.dto.meituancps;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Getter
@Setter
public class MeituanAttributionCallbackDataDto implements Serializable {

    private static final long serialVersionUID = -9012886025742692371L;

    /**
     * 自增主键
     */
    private Long id;

    /**
     * 媒体平台ID
     */
    private Long mediaPlatformId;

    /**
     * 产品ID
     */
    private Long productId;

    /**
     * 任务ID
     */
    private Long taskId;

    /**
     * 投放计划ID
     */
    private Long planId;

    /**
     * 推啊链路追踪ID
     * @see cn.com.duiba.tuia.purchase.web.api.util.PbpOrderNoUtils
     */
    private String trackId;

    /**
     * 推啊数据类型
     */
    private String aEventType;

    /**
     * 媒体数据类型
     */
    private String mEventType;

    /**
     * 回传策略ID
     */
    private Long strategyId;

    /**
     * 回传状态：0-待回传、1-已回传
     */
    private Integer cbStatus;

    /**
     * 扩展数据（监测上报、归因回传综合数据）
     */
    private ExtCallbackData extCallbackData;

    /**
     * 决策数据（冗余下来的决策依据数据）
     */
    private DecisionData decisionData;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    @Getter
    @Setter
    public static class ExtCallbackData implements Serializable {
        private static final long serialVersionUID = -4863239592432595539L;
        /**
         * 单价
         */
        private BigDecimal unitPrice;
        /**
         * 佣金
         */
        private BigDecimal fee;
        /**
         * 商户ID
         */
        private String merchantId;
        /**
         * 商品ID
         */
        private String itemId;
    }

    @Getter
    @Setter
    public static class DecisionData implements Serializable {
        private static final long serialVersionUID = 8868836330659235048L;
        private Long winnerId;
        private String winnerTrackId;
    }

}
