/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.purchase.web.api.constant;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum ChargeType {
    CPC(1, "CPC"),
    CPA(2, "CPA");

    private Integer code;
    private String name;

    private ChargeType(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<ChargeType> getByCode(Integer chargeTypeCode) {
        if (Objects.isNull(chargeTypeCode)) {
            return Optional.empty();
        }
        return Arrays.stream(ChargeType.values()).filter(e -> Objects.equals(e.getCode(), chargeTypeCode)).findAny();
    }

    public static Optional<ChargeType> getByName(String name) {
        if (Objects.isNull(name)) {
            return Optional.empty();
        }
        return Arrays.stream(ChargeType.values()).filter(e -> Objects.equals(e.getName(), name)).findAny();
    }
}

