package cn.com.duiba.tuia.purchase.web.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhongda & ikongyi
 */
public enum PbpMQTagEnum {
    /**
     * 媒体返点变更
     */
    MEDIA_REBATE_RATE_CHANGE("mediaRebateRateChange", "媒体返点变更"),
    /**
     * 归因回传媒体
     */
    AD_ATTRIBUTION_CALLBACK("adAttributionCallback", "归因回传媒体"),
    /**
     * 添加人群包
     */
    ADD_CROWD_PACKAGE("addCrowdPackageMsgTag", "添加人群包")
    ;

    private static final Map<String, PbpMQTagEnum> TAG_ENUM_MAP = Arrays.stream(values()).collect(Collectors.toMap(PbpMQTagEnum::getCode, Function.identity()));

    private String code;
    private String desc;

    PbpMQTagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Optional<PbpMQTagEnum> getByCode(String code) {
        return Optional.ofNullable(TAG_ENUM_MAP.get(code));
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
