/**
 * 文件名： CreateAdverReq.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月5日 下午2:38:27
 */
package cn.com.duiba.tuia.risk.center.api.dto;

import com.google.common.collect.Lists;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 广告表.
 *
 * @author: youhaijun
 * @version:
 */
public class LandPageSourceDto implements Serializable {


    private Long id;
    /**
     * 广告计划ID.
     */
    private Long advertId;

    /**
     * 名称.
     */
    private String advertName;

    /**
     * 推广计划链接
     */
    private String premoteUrl;
    private String sourcePages;
    private List<LandPageContrastDto> contrastList;
    private List<LandPageContrastDto> sourceList;


    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }


    public String getSourcePages() {
        return sourcePages;
    }

    public List<Long> getSourcePagesList() {
        ArrayList<Long> result = Lists.newArrayList();
        if (!StringUtils.isEmpty(this.sourcePages)) {
            for (String s : sourcePages.split(",")) {
                if (!StringUtils.isEmpty(s)) {
                    result.add(Long.parseLong(s));
                }
            }
        }
        return result;
    }

    public void setSourcePages(String sourcePages) {
        this.sourcePages = sourcePages;
    }

    public void setSourcePages(String sourcePages, Long id) {
        if (StringUtils.isEmpty(sourcePages)) {
            this.sourcePages = id.toString();
        } else {
            this.sourcePages = new StringBuilder(sourcePages).append(",").append(id).toString();
        }
    }

    public List<LandPageContrastDto> getSourceList() {
        return sourceList;
    }

    public void setSourceList(List<LandPageContrastDto> sourceList) {
        this.sourceList = sourceList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }


    public String getPremoteUrl() {
        return premoteUrl;
    }

    public void setPremoteUrl(String premoteUrl) {
        this.premoteUrl = premoteUrl;
    }

    public List<LandPageContrastDto> getContrastList() {
        return contrastList;
    }

    public void setContrastList(List<LandPageContrastDto> contrastList) {
        this.contrastList = contrastList;
    }

}
