package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel
public class HandleRecord implements Serializable {

	@ApiModelProperty("广告位ID")
	private Long slotId;
	@ApiModelProperty("广告位名称")
	private String slotName;
	@ApiModelProperty("日期")
	private String curDate;
	@ApiModelProperty("作弊等级")
	private String cheatGrade;
	@ApiModelProperty("初步处理结果")
	private Integer preResult;
	@ApiModelProperty("初步处理人")
	private String preRiskReviewer;
	@ApiModelProperty("最终处理结果")
	private Integer reviewResult;
	@ApiModelProperty("最终处理人")
	private String riskReviewer;
	@ApiModelProperty("备注")
	private String reviewRemarks;

	public Long getSlotId() {
		return slotId;
	}

	public void setSlotId(Long slotId) {
		this.slotId = slotId;
	}

	public String getSlotName() {
		return slotName;
	}

	public void setSlotName(String slotName) {
		this.slotName = slotName;
	}

	public String getCurDate() {
		return curDate;
	}

	public void setCurDate(String curDate) {
		this.curDate = curDate;
	}

	public String getCheatGrade() {
		return cheatGrade;
	}

	public void setCheatGrade(String cheatGrade) {
		this.cheatGrade = cheatGrade;
	}

	public Integer getPreResult() {
		return preResult;
	}

	public void setPreResult(Integer preResult) {
		this.preResult = preResult;
	}

	public String getPreRiskReviewer() {
		return preRiskReviewer;
	}

	public void setPreRiskReviewer(String preRiskReviewer) {
		this.preRiskReviewer = preRiskReviewer;
	}

	public Integer getReviewResult() {
		return reviewResult;
	}

	public void setReviewResult(Integer reviewResult) {
		this.reviewResult = reviewResult;
	}

	public String getRiskReviewer() {
		return riskReviewer;
	}

	public void setRiskReviewer(String riskReviewer) {
		this.riskReviewer = riskReviewer;
	}

	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;

		HandleRecord that = (HandleRecord) o;

		if (slotId != null ? !slotId.equals(that.slotId) : that.slotId != null) return false;
		if (slotName != null ? !slotName.equals(that.slotName) : that.slotName != null) return false;
		if (curDate != null ? !curDate.equals(that.curDate) : that.curDate != null) return false;
		if (cheatGrade != null ? !cheatGrade.equals(that.cheatGrade) : that.cheatGrade != null) return false;
		if (preResult != null ? !preResult.equals(that.preResult) : that.preResult != null) return false;
		if (preRiskReviewer != null ? !preRiskReviewer.equals(that.preRiskReviewer) : that.preRiskReviewer != null)
			return false;
		if (reviewResult != null ? !reviewResult.equals(that.reviewResult) : that.reviewResult != null) return false;
		if (riskReviewer != null ? !riskReviewer.equals(that.riskReviewer) : that.riskReviewer != null) return false;
		return reviewRemarks != null ? reviewRemarks.equals(that.reviewRemarks) : that.reviewRemarks == null;
	}

	@Override
	public int hashCode() {
		int result = slotId != null ? slotId.hashCode() : 0;
		result = 31 * result + (slotName != null ? slotName.hashCode() : 0);
		result = 31 * result + (curDate != null ? curDate.hashCode() : 0);
		result = 31 * result + (cheatGrade != null ? cheatGrade.hashCode() : 0);
		result = 31 * result + (preResult != null ? preResult.hashCode() : 0);
		result = 31 * result + (preRiskReviewer != null ? preRiskReviewer.hashCode() : 0);
		result = 31 * result + (reviewResult != null ? reviewResult.hashCode() : 0);
		result = 31 * result + (riskReviewer != null ? riskReviewer.hashCode() : 0);
		result = 31 * result + (reviewRemarks != null ? reviewRemarks.hashCode() : 0);
		return result;
	}

	@Override
	public String toString() {
		return "HandleRecord{" + "slotId=" + slotId + ", slotName='" + slotName + '\'' + ", curDate=" + curDate + ", cheatGrade='" + cheatGrade + '\'' + ", preResult=" + preResult + ", preRiskReviewer='" + preRiskReviewer + '\'' + ", reviewResult=" + reviewResult + ", riskReviewer='" + riskReviewer + '\'' + ", reviewRemarks='" + reviewRemarks + '\'' + '}';
	}
}
