package cn.com.duiba.tuia.risk.center.api.dto;

import java.math.BigDecimal;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Data
public class SlotCheatInfo {
	private Long appId;
	private Long dwsId;
	private Long slotId;
	private Integer cheatGrade;
	private BigDecimal adConsume;
	private BigDecimal cheatFee;
	private Integer todayRate;
	private Integer adviceRate;
	private Integer handleResult;

	public Integer calAdviceRate() {
		log.info("cal advice rate - " + this);
		try {
			adviceRate = adConsume.subtract(cheatFee).multiply((new BigDecimal(todayRate))).divide(adConsume, 0, BigDecimal.ROUND_HALF_DOWN).intValue();
		} catch (Exception e) {
			log.error(e.getMessage());
			adviceRate = 0;
		}
		return adviceRate;
	}
}
