package cn.com.duiba.tuia.risk.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.EngineSceneDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.EngineSceneParam;

/**
 * 规则引擎场景信息服务 ClassName: RemoteEngineSceneService <br/>
 * date: 2018年7月23日 下午6:45:20 <br/>
 * .
 *
 * @author lijian
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteEngineSceneService {


    /**
     * @Description: 分页查询规则引擎场景信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    PageResultDto<EngineSceneDto> queryPage(EngineSceneParam param);

    /**
     * @Description: 新增规则引擎场景信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    Integer save(EngineSceneDto dto);

    /**
     * @Description: 更新规则引擎场景信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    Integer update(EngineSceneDto dto);

    /**
     * @Description: 删除规则引擎场景信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    Integer delete(EngineSceneDto dto);

    /**
     * @Description: 根据id或全量查询规则引擎场景名称
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    List<EngineSceneDto> queryAllScene(List<Long> ids);

    /**
     * @Description: 校验场景名称，场景标识是否重复
     * @Param:
     * @return:  ture 为不重复
     * @Author: lijian
     * @Date: 2018/7/23
     */
    Boolean checkSceneKeyOrName(EngineSceneDto dto);
}
