/**
 * Project Name:activity-center-api<br>
 * File Name:EncryptType.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.constant<br>
 * Date:2017年4月17日上午11:06:35<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */
package cn.com.duiba.tuia.risk.center.api.constant;


/**
 * ClassName: EncryptType <br/>
 * Function: 加密类型枚举. <br/>
 * Reason: . <br/>
 * date: 2017年4月17日 上午11:06:35 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
public enum EncryptType {
    
    /** 
     * MD5: MD5加密
     * encryptName = MD5(参数1+参数2...+ encryptKey )
     */
    MD5(1,"md5"),
    
    /** 
     * CONSTENT: 固定值
     * encryptName=encryptKey
     */
    CONSTENT(2,"constent"),
    
    /**
     * DES:加密 (单个参数)
     * encryptName = DES(sdo.getString(encryptName),encryptKey)
     */
    SINGLE_DES(3,"des");
    
    private Integer type;

    /** desc:描述. */
    private String  desc;

    /**
     * Creates a new instance of EncryptType.
     *
     * @param type
     * @param desc
     */
    
    EncryptType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    
    public Integer getType() {
        return type;
    }

    
    public String getDesc() {
        return desc;
    }
    
    
}
