package cn.com.duiba.tuia.risk.center.api.dto.req;

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class BlacklistUpdateParam implements Serializable {

    private static final long serialVersionUID = 1L;

	@NotNull(message = "id不能为空")
	@Min(value = 1, message = "id最小值为1")
	private Long id;

	@NotNull(message = "名单值不能为空")
	@Length(max = 56, message = "名单值最大长度为56位")
	@ApiModelProperty("名单值")
	private String  val;

	private String valOld;

    private Integer riskRank;

	@NotNull(message = "状态不能为空")
	@Range(min = 0, max = 1, message = "状态参数值不在范围内")
	@ApiModelProperty("状态 0-启用 1-禁用")
	private Integer stat;

	@Length(max = 56, message = "来源最大长度为56位")
	@ApiModelProperty("来源")
	private String  src;

	@Length(max = 64, message = "备注最大长度为64位")
	@ApiModelProperty("备注")
	private String  memo;

	@ApiModelProperty("更新时间")
	private Date gmtModified;
	
	@ApiModelProperty("更新人")
	private String mender;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}



	public Integer getStat() {
		return stat;
	}

	public void setStat(Integer stat) {
		this.stat = stat;
	}

	public String getVal() {
		return val;
	}

	public void setVal(String val) {
		this.val = val;
	}

	public String getSrc() {
		return src;
	}

	public void setSrc(String src) {
		this.src = src;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getMender() {
		return mender;
	}

	public void setMender(String mender) {
		this.mender = mender;
	}

    public String getValOld() {
        return valOld;
    }

    public void setValOld(String valOld) {
        this.valOld = valOld;
    }

    public Integer getRiskRank() {
        return riskRank;
    }

    public void setRiskRank(Integer riskRank) {
        this.riskRank = riskRank;
    }
}
