package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
* 条件表
*/
@Data
@ApiModel
public class EngineConditionDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 
    */
    private Long id;

    /**
    * 规则ID
    */
    @ApiModelProperty("规则ID")
    private Long ruleId;

    /**
    * 字段id
    */
    @NotNull(message = "字段id不能为空")
    @ApiModelProperty("字段id")
    private Long fieldId;

     /**
    * 操作符
    */
    @ApiModelProperty("操作符  " +
	    ">：0数值型变量比较，\n" +
	    "<：1数值型变量比较\n" +
	    "=：2数值型或字符串型变量比较\n" +
	    ">=：3数值型变量比较\n" +
	    "<=：4数值型变量比较\n" +
	    "≠：5数值型或字符串型变量比较\n" +
	    ">and<=：6数值型变量比较\n" +
	    ">and<：7数值型变量比较\n" +
	    ">=and<：8数值型变量比较\n" +
	    ">=and<=：9数值型变量比较\n" +
	    "包含：10字符串型变量比较\n" +
	    "不包含：11字符串型变量比较")
    @NotNull(message = "操作符不能为空")
    @Range(max = 11L)
    private Integer operation;

    /**
    * 阈值
    */
    @NotEmpty(message = "阈值不能为空")
    @ApiModelProperty("阈值")
    private String threshold;

    /**
    * 创建者
    */
    private String creator;

    /**
    * 修改者
    */
    private String editor;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

