package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.conversions.DateConversion;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 *
 */
@ApiModel
public class RiskSlotDimensionStatisDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @Parsed(field = "日期", defaultNullWrite = "")
    @Convert(conversionClass = DateConversion.class, args = "yyyy-MM-dd")
    private Date curDate;

    /**
     * 广告位ID
     */
    @ApiModelProperty("广告位ID")
    @Parsed(field = "广告位ID", defaultNullWrite = "")
    private Long slotId;

    /**
     * 媒体ID
     */
    @ApiModelProperty("媒体ID")
    @Parsed(field = "媒体ID", defaultNullWrite = "")
    private Long appId;


    @ApiModelProperty("维度：0-ip、1-device、2-ua、3-city、4-设备品牌、5-浏览器、6-操作系统版本、7-网络类型")
    @Parsed(field = "维度：0-ip、1-device、2-ua、3-city、4-设备品牌、5-浏览器、6-操作系统版本、7-网络类型", defaultNullWrite = "")
    private Integer dimension;

    @ApiModelProperty("IP、device_id、UserAgent、city、设备品牌、浏览器、操作系统版本、网络类型")
    @Parsed(field = "维度值", defaultNullWrite = "")
    private String metric;

    /**
     * 访问占比 该IP广告位访问PV/当天广告位访问总PV
     */
    @ApiModelProperty("访问占比 该IP广告位访问PV/当天广告位访问总PV")
    private Double visitRate;


    /**
     * 该维度广告位访问uv
     */
    @ApiModelProperty("该维度广告位访问uv")
    @Parsed(field = "广告位访问uv", defaultNullWrite = "")
    private Long sdkUv;

    /**
     * 该维度活动参与pv
     */
    @ApiModelProperty("该维度活动参与pv")
    @Parsed(field = "活动参与pv", defaultNullWrite = "")
    private Long participatePv;

    /**
     * 该维度活动参与uv
     */
    @ApiModelProperty("该维度活动参与uv")
    @Parsed(field = "活动参与uv", defaultNullWrite = "")
    private Long participateUv;

    /**
     * 该维度发劵量
     */
    @ApiModelProperty("该维度发劵量")
    @Parsed(field = "发劵量", defaultNullWrite = "")
    private Long launchCount;

    /**
     * 总发券量
     */
    @ApiModelProperty("总发券量")
    @Parsed(field = "总发券量", defaultNullWrite = "")
    private Long slotLaunchCount;

    /**
     * 发券量占比：发券量/广告位当天总发券量
     */
    @ApiModelProperty("发券量占比")
    @Parsed(field = "发券量占比", defaultNullWrite = "")
    private Double launchRate;

    /**
     * 该维度劵曝光量
     */
    @ApiModelProperty("该维度劵曝光量")
    @Parsed(field = "劵曝光量", defaultNullWrite = "")
    private Long exposureCount;

    /**
     * 该维度点击pv
     */
    @ApiModelProperty("该维度点击pv")
    @Parsed(field = "点击pv", defaultNullWrite = "")
    private Long clickCount;

    /**
     * ctr=该维度点击pv/该维度劵曝光量
     */
    @ApiModelProperty("ctr=该维度点击pv/该维度劵曝光量")
    @Parsed(field = "ctr", defaultNullWrite = "")
    private Double ctr;

    /**
     * 该维度落地页访问pv
     */
    @ApiModelProperty("该维度落地页访问pv")
    @Parsed(field = "落地页访问pv", defaultNullWrite = "")
    private Long promoteVisitPv;

    /**
     * 该维度落地页访问uv
     */
    @ApiModelProperty("该维度落地页访问uv")
    @Parsed(field = "落地页访问uv", defaultNullWrite = "")
    private Long promoteVisitUv;

    /**
     * 该维度落地页转化pv
     */
    @ApiModelProperty("该维度落地页转化pv")
    @Parsed(field = "落地页转化pv", defaultNullWrite = "")
    private Long effectPv;

    /**
     * cvr=该维度落地页转化PV/该维度落地页访问PV
     */
    @ApiModelProperty("cvr=该维度落地页转化PV/该维度落地页访问PV")
    @Parsed(field = "cvr", defaultNullWrite = "")
    private Double cvr;

    @ApiModelProperty("是否在黑名单中 0-否 1-是")
    @Parsed(field = "是否在黑名单中(0-否 1-是)", defaultNullWrite = "")
    private Integer belongBlacklist;


    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getDimension() {
        return dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public String getMetric() {
        return metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Double getVisitRate() {
        return visitRate;
    }

    public void setVisitRate(Double visitRate) {
        this.visitRate = visitRate;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getParticipatePv() {
        return participatePv;
    }

    public void setParticipatePv(Long participatePv) {
        this.participatePv = participatePv;
    }

    public Long getParticipateUv() {
        return participateUv;
    }

    public void setParticipateUv(Long participateUv) {
        this.participateUv = participateUv;
    }

    public Long getLaunchCount() {
        return launchCount;
    }

    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    public Long getSlotLaunchCount() {
        return slotLaunchCount;
    }

    public void setSlotLaunchCount(Long slotLaunchCount) {
        this.slotLaunchCount = slotLaunchCount;
    }

    public Double getLaunchRate() {
        return launchRate;
    }

    public void setLaunchRate(Double launchRate) {
        this.launchRate = launchRate;
    }

    public Long getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Double getCtr() {
        return ctr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Long getPromoteVisitPv() {
        return promoteVisitPv;
    }

    public void setPromoteVisitPv(Long promoteVisitPv) {
        this.promoteVisitPv = promoteVisitPv;
    }

    public Long getPromoteVisitUv() {
        return promoteVisitUv;
    }

    public void setPromoteVisitUv(Long promoteVisitUv) {
        this.promoteVisitUv = promoteVisitUv;
    }

    public Long getEffectPv() {
        return effectPv;
    }

    public void setEffectPv(Long effectPv) {
        this.effectPv = effectPv;
    }

    public Double getCvr() {
        return cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public Integer getBelongBlacklist() {
        return belongBlacklist;
    }

    public void setBelongBlacklist(Integer belongBlacklist) {
        this.belongBlacklist = belongBlacklist;
    }

    @Override
    public String toString() {
        return "RiskSlotDimensionStatisDto{" +
                "curDate=" + curDate +
                ", slotId=" + slotId +
                ", appId=" + appId +
                ", dimension=" + dimension +
                ", metric='" + metric + '\'' +
                ", visitRate=" + visitRate +
                ", sdkUv=" + sdkUv +
                ", participatePv=" + participatePv +
                ", participateUv=" + participateUv +
                ", launchCount=" + launchCount +
                ", slotLaunchCount=" + slotLaunchCount +
                ", launchRate=" + launchRate +
                ", exposureCount=" + exposureCount +
                ", clickCount=" + clickCount +
                ", ctr=" + ctr +
                ", promoteVisitPv=" + promoteVisitPv +
                ", promoteVisitUv=" + promoteVisitUv +
                ", effectPv=" + effectPv +
                ", cvr=" + cvr +
                ", belongBlacklist=" + belongBlacklist +
                '}';
    }
}