package cn.com.duiba.tuia.risk.center.api.dto.req;


import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.tuia.risk.center.api.constant.AnalysisDimension;
import cn.com.duiba.tuia.risk.center.api.constant.Target;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

@Data
@ApiModel
public class DashBoardParam implements Serializable {

    @ApiModelProperty("开始时间 yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;
    @ApiModelProperty("结束时间 yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;
    @ApiModelProperty("维度")
    private AnalysisDimension analysisDimension;
    @ApiModelProperty("指标")
    private Target target;
    private Integer top;
}
