package cn.com.duiba.tuia.risk.center.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.*;
import cn.com.duiba.tuia.risk.center.api.dto.req.SlotStatisParam;
import cn.com.duiba.tuia.risk.center.api.dto.req.SlotStatisticParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRiskSlotStatisService {
    PageResultDto<RiskSlotStatisDto> pageSlot(SlotStatisParam param);
    PageResultDto<RiskSlotIpStatisDto> pageSlotIp(SlotStatisParam param);
    PageResultDto<RiskSlotUAStatisDto> pageSlotUA(SlotStatisParam param);
    PageResultDto<RiskSlotDeviceStatisDto> pageSlotDevice(SlotStatisParam param);
    PageResultDto<RiskSlotCityStatisDto> pageSlotCity(SlotStatisParam param);

    /**
     * @Description: 根据日期维度等信息分页查询各维度的数据
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/11/5
     */
    PageResultDto<RiskSlotDimensionStatisDto> pageSlotForDimension(SlotStatisticParam param);
    /**
     * @Description: 根据日期维度等信息汇总出仪表盘数据
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/11/5
     */
    List<RiskSlotDimensionStatisDto> getMeterDimensionSum(SlotStatisticParam param);
}
