package cn.com.duiba.tuia.risk.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.HistoryWaveDto;
import cn.com.duiba.tuia.risk.center.api.dto.RpsWaveAnalysis;
import cn.com.duiba.tuia.risk.center.api.dto.req.HistoryWaveParam;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqSlotWaveAnalysis;

@AdvancedFeignClient
public interface RemoteSlotWaveAnalysisService {

    /**
     * @Description: 波动分析作弊汇总数据
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/9/19
     */
    RpsWaveAnalysis getWaveAnalysisSum(ReqSlotWaveAnalysis req);

    /**
     * @Description: 分页查询波动分析数据
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/9/19
     */
    PageResultDto<RpsWaveAnalysis> queryPage(ReqSlotWaveAnalysis req);

    /**
     * @Description: 查询广告位波动分析数据
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/9/19
     */
    List<RpsWaveAnalysis> getSlotWaveAnalysis(ReqSlotWaveAnalysis req);

    List<HistoryWaveDto> cheatAndHitCount(HistoryWaveParam param);

    List<HistoryWaveDto> totalConsume(HistoryWaveParam param);

}
