package cn.com.duiba.tuia.risk.center.api.dto;

import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.conversions.DateConversion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
* 作弊识别明细表
*/
@ApiModel
public class CheatIdentDetailDto implements Serializable {

    private static final long serialVersionUID = -1578793360015486897L;

    /**
    * 主键
    */
    @ApiModelProperty("主键")
    private Long id;

    /**
    * 日期
    */
    @ApiModelProperty("日期")
    @Parsed(field = "日期", defaultNullWrite = "")
    @Convert(conversionClass = DateConversion.class, args = "yyyy-MM-dd")
    private Date curDate;

    /**
    * 大盘总消耗(分)
    */
    @ApiModelProperty("大盘总消耗")
    @Parsed(field = "大盘总消耗", defaultNullWrite = "")
    private Long totalConsume;

    /**
    * 总作弊消耗(分)
    */
    @ApiModelProperty("总作弊消耗")
    @Parsed(field = "总作弊消耗", defaultNullWrite = "")
    private Long cheatConsume;

    /**
    * 作弊识别率：总作弊消耗 / 大盘总消耗
    */
    @ApiModelProperty("作弊识别率")
    @Parsed(field = "作弊识别率", defaultNullWrite = "")
    private Double cheatIdentRate;

    /**
    * 风险广告位总消耗
    */
    @ApiModelProperty("风险广告位总消耗")
    @Parsed(field = "风险广告位总消耗", defaultNullWrite = "")
    private Long slotConsume;

    /**
    * 风险广告位作弊消耗
    */
    @ApiModelProperty("风险广告位作弊消耗")
    @Parsed(field = "风险广告位作弊消耗", defaultNullWrite = "")
    private Long slotCheatConsume;

    /**
    * 风险广告位作弊识别率：风险媒体作弊消耗/总作弊消耗
    */
    @ApiModelProperty("风险广告位作弊识别率")
    @Parsed(field = "风险广告位作弊识别率", defaultNullWrite = "")
    private Double slotCheatRate;

    /**
    * A类规则作弊消耗
    */
    @ApiModelProperty("A类规则作弊消耗")
    @Parsed(field = "A类规则作弊消耗", defaultNullWrite = "")
    private Long acheatConsume;

    /**
    * C类实际作弊消耗
    */
    @ApiModelProperty("C类实际作弊消耗")
    @Parsed(field = "C类实际作弊消耗", defaultNullWrite = "")
    private Long ccheatConsume;

    /**
    * C类拦截作弊消耗
    */
    @ApiModelProperty("C类拦截作弊消耗")
    @Parsed(field = "C类拦截作弊消耗", defaultNullWrite = "")
    private Long cstopcheatConsume;

    /**
    * A类规则作弊消耗占比：A类规则作弊消耗/总作弊消耗
    */
    @ApiModelProperty("A类规则作弊消耗占比")
    @Parsed(field = "A类规则作弊消耗占比", defaultNullWrite = "")
    private Double acheatRate;

    /**
    * C类实际作弊消耗占比：C类实际作弊消耗/总作弊消耗
    */
    @ApiModelProperty("C类实际作弊消耗占比")
    @Parsed(field = "C类实际作弊消耗占比", defaultNullWrite = "")
    private Double ccheatRate;

    /**
    * C类拦截作弊消耗占比：C类拦截作弊消耗/总作弊消耗
    */
    @ApiModelProperty("C类拦截作弊消耗占比")
    @Parsed(field = "C类拦截作弊消耗占比", defaultNullWrite = "")
    private Double cstopcheatRate;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getTotalConsume() {
        return totalConsume;
    }

    public void setTotalConsume(Long totalConsume) {
        this.totalConsume = totalConsume;
    }

    public Long getCheatConsume() {
        return cheatConsume;
    }

    public void setCheatConsume(Long cheatConsume) {
        this.cheatConsume = cheatConsume;
    }

    public Double getCheatIdentRate() {
        return cheatIdentRate;
    }

    public void setCheatIdentRate(Double cheatIdentRate) {
        this.cheatIdentRate = cheatIdentRate;
    }

    public Long getSlotConsume() {
        return slotConsume;
    }

    public void setSlotConsume(Long slotConsume) {
        this.slotConsume = slotConsume;
    }

    public Long getSlotCheatConsume() {
        return slotCheatConsume;
    }

    public void setSlotCheatConsume(Long slotCheatConsume) {
        this.slotCheatConsume = slotCheatConsume;
    }

    public Double getSlotCheatRate() {
        return slotCheatRate;
    }

    public void setSlotCheatRate(Double slotCheatRate) {
        this.slotCheatRate = slotCheatRate;
    }

    public Long getAcheatConsume() {
        return acheatConsume;
    }

    public void setAcheatConsume(Long acheatConsume) {
        this.acheatConsume = acheatConsume;
    }

    public Long getCcheatConsume() {
        return ccheatConsume;
    }

    public void setCcheatConsume(Long ccheatConsume) {
        this.ccheatConsume = ccheatConsume;
    }

    public Long getCstopcheatConsume() {
        return cstopcheatConsume;
    }

    public void setCstopcheatConsume(Long cstopcheatConsume) {
        this.cstopcheatConsume = cstopcheatConsume;
    }

    public Double getAcheatRate() {
        return acheatRate;
    }

    public void setAcheatRate(Double acheatRate) {
        this.acheatRate = acheatRate;
    }

    public Double getCcheatRate() {
        return ccheatRate;
    }

    public void setCcheatRate(Double ccheatRate) {
        this.ccheatRate = ccheatRate;
    }

    public Double getCstopcheatRate() {
        return cstopcheatRate;
    }

    public void setCstopcheatRate(Double cstopcheatRate) {
        this.cstopcheatRate = cstopcheatRate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

