package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel
public class RiskSlotReviewRecordDto implements Serializable {

    private static final long serialVersionUID = 92059235613198519L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("广告ID")
    private Long advertId;

    @ApiModelProperty("审核时间")
    private Date reviewTime;

    @ApiModelProperty("广告名字")
    private String advertName;

    @ApiModelProperty("资源审核状态 1-拒绝 2-通过")
    private Integer reviewStatus;

    @ApiModelProperty("资源的url")
    private String resourceUrl;

    @ApiModelProperty("敏感词")
    private String violationWords;

    @ApiModelProperty("url类型 0-落地页 1-二次跳转页面")
    private Integer urlType;

    @ApiModelProperty("url")
    private String landingUrl;

    @ApiModelProperty("审核理由")
    private String reviewReason;

    @ApiModelProperty("审核人")
    private String reviewer;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("提交时间")
    private Date commitTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public String getResourceUrl() {
        return resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getReviewReason() {
        return reviewReason;
    }

    public void setReviewReason(String reviewReason) {
        this.reviewReason = reviewReason;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getCommitTime() {
        return commitTime;
    }

    public void setCommitTime(Date commitTime) {
        this.commitTime = commitTime;
    }

    public void setViolationWords(String violationWords) {
        this.violationWords = violationWords;
    }

    public Integer getUrlType() {
        return urlType;
    }

    public void setUrlType(Integer urlType) {
        this.urlType = urlType;
    }

    public String getLandingUrl() {
        return landingUrl;
    }

    public void setLandingUrl(String landingUrl) {
        this.landingUrl = landingUrl;
    }

    public String getViolationWords() {
        return violationWords;
    }

}
