package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.conversions.DateConversion;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * tb_risk_slot_ua_statis
 */
@ApiModel
public class RiskSlotUAStatisDto implements Serializable {
    /**
     * 主键
     */
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @Parsed(field = "日期", defaultNullWrite = "")
    @Convert(conversionClass = DateConversion.class, args = "yyyy-MM-dd")
    private Date curDate;

    /**
     * 广告位ID
     */
    @ApiModelProperty("广告位ID")
    @Parsed(field = "广告位ID", defaultNullWrite = "")
    private Long slotId;

    /**
     * 媒体ID
     */
    @ApiModelProperty("媒体ID")
    @Parsed(field = "媒体ID", defaultNullWrite = "")
    private Long appId;

    /**
     * user-agent
     */
    @ApiModelProperty("user-agent")
    @Parsed(field = "user-agent", defaultNullWrite = "")
    private String ua;

    /**
     * 访问占比 该ua广告位访问PV/当天广告位访问总PV
     */
    @ApiModelProperty("访问占比 该ua广告位访问PV/当天广告位访问总PV")
    private Double visitRate;

    /**
     * 该ua广告位访问uv
     */
    @ApiModelProperty("该ua广告位访问uv")
    @Parsed(field = "广告位访问uv", defaultNullWrite = "")
    private Long sdkUv;

    /**
     * 该ua活动参与pv
     */
    @ApiModelProperty("该ua活动参与pv")
    @Parsed(field = "活动参与pv", defaultNullWrite = "")
    private Long participatePv;

    /**
     * 该ua活动参与uv
     */
    @ApiModelProperty("该ua活动参与uv")
    @Parsed(field = "活动参与uv", defaultNullWrite = "")
    private Long participateUv;

    /**
     * 该ua发劵量
     */
    @ApiModelProperty("该ua发劵量")
    @Parsed(field = "发劵量", defaultNullWrite = "")
    private Long launchCount;

    /**
     * 该ua劵曝光量
     */
    @ApiModelProperty("该ua劵曝光量")
    @Parsed(field = "劵曝光量", defaultNullWrite = "")
    private Long exposureCount;

    /**
     * 该ua点击pv
     */
    @ApiModelProperty("该ua点击pv")
    @Parsed(field = "点击pv", defaultNullWrite = "")
    private Long clickCount;

    /**
     * ctr=该ua点击pv/该ua劵曝光量
     */
    @ApiModelProperty("ctr=该ua点击pv/该ua劵曝光量")
    @Parsed(field = "ctr", defaultNullWrite = "")
    private Double ctr;

    /**
     * 该ua落地页访问pv
     */
    @ApiModelProperty("该ua落地页访问pv")
    @Parsed(field = "落地页访问pv", defaultNullWrite = "")
    private Long promoteVisitPv;

    /**
     * 该ua落地页访问uv
     */
    @ApiModelProperty("该ua落地页访问uv")
    @Parsed(field = "落地页访问uv", defaultNullWrite = "")
    private Long promoteVisitUv;

    /**
     * 该ua落地页转化pv
     */
    @ApiModelProperty("该ua落地页转化pv")
    @Parsed(field = "落地页转化pv", defaultNullWrite = "")
    private Long effectPv;

    /**
     * cvr=该ua落地页转化PV/该ua落地页访问PV
     */
    @ApiModelProperty("cvr=该ua落地页转化PV/该ua落地页访问PV")
    @Parsed(field = "cvr", defaultNullWrite = "")
    private Double cvr;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("是否在黑名单中 0-否 1-是")
    @Parsed(field = "是否在黑名单中(0-否 1-是)", defaultNullWrite = "")
    private Integer belongBlacklist;

    public Integer getBelongBlacklist() {
        return belongBlacklist;
    }

    public void setBelongBlacklist(Integer belongBlacklist) {
        this.belongBlacklist = belongBlacklist;
    }
    /**
     * tb_risk_slot_ua_statis
     */
    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua == null ? null : ua.trim();
    }

    public Double getVisitRate() {
        return visitRate;
    }

    public void setVisitRate(Double visitRate) {
        this.visitRate = visitRate;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getParticipatePv() {
        return participatePv;
    }

    public void setParticipatePv(Long participatePv) {
        this.participatePv = participatePv;
    }

    public Long getParticipateUv() {
        return participateUv;
    }

    public void setParticipateUv(Long participateUv) {
        this.participateUv = participateUv;
    }

    public Long getLaunchCount() {
        return launchCount;
    }

    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    public Long getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Double getCtr() {
        return ctr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Long getPromoteVisitPv() {
        return promoteVisitPv;
    }

    public void setPromoteVisitPv(Long promoteVisitPv) {
        this.promoteVisitPv = promoteVisitPv;
    }

    public Long getPromoteVisitUv() {
        return promoteVisitUv;
    }

    public void setPromoteVisitUv(Long promoteVisitUv) {
        this.promoteVisitUv = promoteVisitUv;
    }

    public Long getEffectPv() {
        return effectPv;
    }

    public void setEffectPv(Long effectPv) {
        this.effectPv = effectPv;
    }

    public Double getCvr() {
        return cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", curDate=").append(curDate);
        sb.append(", slotId=").append(slotId);
        sb.append(", appId=").append(appId);
        sb.append(", ua=").append(ua);
        sb.append(", visitRate=").append(visitRate);
        sb.append(", sdkUv=").append(sdkUv);
        sb.append(", participatePv=").append(participatePv);
        sb.append(", participateUv=").append(participateUv);
        sb.append(", launchCount=").append(launchCount);
        sb.append(", exposureCount=").append(exposureCount);
        sb.append(", clickCount=").append(clickCount);
        sb.append(", ctr=").append(ctr);
        sb.append(", promoteVisitPv=").append(promoteVisitPv);
        sb.append(", promoteVisitUv=").append(promoteVisitUv);
        sb.append(", effectPv=").append(effectPv);
        sb.append(", cvr=").append(cvr);
        sb.append(", gmtCreate=").append(gmtCreate);
        sb.append(", gmtModified=").append(gmtModified);
        sb.append("]");
        return sb.toString();
    }
}