package cn.com.duiba.tuia.risk.center.api.dto.req;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import cn.com.duiba.tuia.risk.center.api.dto.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@ApiModel
@EqualsAndHashCode(callSuper = true)
@Data
public class SlotStatisParam extends PageParam {
    @ApiModelProperty("开始时间 yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date   startTime;
    @ApiModelProperty("结束时间 yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date   endTime;
    @ApiModelProperty("广告位id")
    private Long   slotId;
    @ApiModelProperty("媒体id")
    private Long   appId;
    @ApiModelProperty("ip")
    private String ip;
    @ApiModelProperty("ua")
    private String ua;
    @ApiModelProperty("deviceId")
    private String deviceId;
    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("维度：0-ip、1-device、2-ua、3-city、4-设备品牌、5-浏览器、6-操作系统版本、7-网络类型")
    private Integer dimension;

    @ApiModelProperty("IP、device_id、UserAgent、city、设备品牌、浏览器、操作系统版本、网络类型")
    private String metric;

    @ApiModelProperty("排序字段")
    private String field;
    @ApiModelProperty("排列顺序： 0 升序  1 降序")
    private Integer order;
}
