package cn.com.duiba.tuia.risk.center.api.remoteservice;

import java.math.BigDecimal;
import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.DwsIdAdviceRate;
import cn.com.duiba.tuia.risk.center.api.dto.DwsSlotRiskAllDIDto;
import cn.com.duiba.tuia.risk.center.api.dto.HandleRecord;
import cn.com.duiba.tuia.risk.center.api.dto.RiskReviewDto;
import cn.com.duiba.tuia.risk.center.api.dto.SlotCheatInfo;
import cn.com.duiba.tuia.risk.center.api.dto.StatisticShowDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqHandleRecord;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqRiskReviewQuery;


/**
 * ClassName: RemoteRiskReviewService <br/>
 * Function: 风控审核相关service. <br/>
 * date: 2018年2月32日 下午9:15:42 <br/>
 *
 * @author cdm
 * @version
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteRiskReviewService {


    /**
     * queryRiskReviewPage:(查询风控审核列表). <br/>
     *
     *
     * @param reqPageQuery the 分页查询信息
     * @return List<DwsSlotRiskAllDIEntity>  审核信息集合
     * @author cdm
     * @since JDK 1.7
     */
    PageResultDto<DwsSlotRiskAllDIDto> queryRiskReviewPage(ReqRiskReviewQuery reqPageQuery);

    /**
     * queryRiskReviewPage:(查询案例列表). <br/>
     *
     *
     * @param reqPageQuery the 分页查询信息
     * @return List<DwsSlotRiskAllDIEntity>  审核信息集合
     * @author cdm
     * @since JDK 1.7
     */
    PageResultDto<DwsSlotRiskAllDIDto> queryExamplePage(ReqRiskReviewQuery reqPageQuery);

    /**
     * selectByPrimaryKey:(根据主键id查询). <br/>
     *
     * @param id
     * @return ActivityEntity
     */
    RiskReviewDto selectByPrimaryKey(Long id);


    /**
     * updateById:(根据主键id更新). <br/>
     * 全部字段更新.<br/>
     *
     * @author cdm
     * @param record
     * @return int
     * @since JDK 1.7
     */
    int updateById(RiskReviewDto dto);



    /**
     * 根据参数查询活动数量
     *
     * @param reqActivityQuery
     * @return
     */
    int insert(RiskReviewDto dto);

    /**
     * 查询审核界面统计数据
     */
    StatisticShowDto selectCountShow(ReqRiskReviewQuery reqPageQuery);


    int updateInExampleByExampleId(Long id);


	PageResultDto<HandleRecord> queryHandleRecord(ReqHandleRecord req);

	/**
	 * 查询昨天的需要通知媒体管理平台的广告位
	 * @return 符合条件的广告位
	 */
	List<SlotCheatInfo> obSlotsOfYesterday();

	/**
	 * 更新建议分成
	 * @param container 包含dwsId和建议分成的列表
	 */
	void updateAdviceRate(List<DwsIdAdviceRate> container);

    /**
     * 获取离线数据的最终处理金额统计值
     * @return 最终处理金额统计值
     */
    BigDecimal getFinalDealMoney(ReqRiskReviewQuery req);

    /**
     * 获取昨天数据的处理方式
     */
    List<SlotCheatInfo> getSlotsOfYesterday(List<Long> slotIds);

    /**
     * 根据媒体汇总该媒体下各个广告位作弊消耗之和
     */
    List<SlotCheatInfo> getYesterdayCheatData();

    /**
     * 更新昨日的计算出的作弊广告位类型字段
     */
    Integer updateCheatSlotType();
}
