package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 竞品巡查日志表
 */
@ApiModel
public class CompetePatrolLogDto implements Serializable {

    private static final long serialVersionUID = 4855931021363107365L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("竞品id")
    private Long competeId;

    @ApiModelProperty("巡查时间")
    private Date patrolTime;

    @ApiModelProperty("广告素材&落地页URL")
    private String imageUrl;

    @ApiModelProperty("地域")
    private String city;

    @ApiModelProperty("ip地址")
    private String ip;

    @ApiModelProperty("记录创建时间")
    private Date gmtCreate;

    @ApiModelProperty("记录修改时间")
    private Date gmtModified;

    @ApiModelProperty("广告素材&落地页URL列表")
    List<ImageUrl> imageUrls;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCompeteId() {
        return competeId;
    }

    public void setCompeteId(Long competeId) {
        this.competeId = competeId;
    }

    public Date getPatrolTime() {
        return patrolTime;
    }

    public void setPatrolTime(Date patrolTime) {
        this.patrolTime = patrolTime;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public List<ImageUrl> getImageUrls() {
        return imageUrls;
    }

    public void setImageUrls(List<ImageUrl> imageUrls) {
        this.imageUrls = imageUrls;
    }
}

