package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.InterceptPatrolRecordDto;
import cn.com.duiba.tuia.risk.center.api.dto.RiskSlotReviewRecordDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqRiskSlotReviewRecord;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRiskSlotReviewRecordService {

    int insert(RiskSlotReviewRecordDto reviewDto);

    List<RiskSlotReviewRecordDto> query(Long advertId);

    int getTotalCount(Long advertId);

    /**
     * @Description: 分页查询广告审核日志信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/10/30
     */
    PageResultDto<RiskSlotReviewRecordDto> queryPageForRecord(ReqRiskSlotReviewRecord param);


    /**
     * 根据广告主id,篡改类型 查询广告主篡改次数
     */
    Integer getTotalCountByMaster(Long accountId, Integer distortType);

    /**
     * 根据广告主id,篡改类型 更新广告主篡改次数
     */
    Integer updateDistortCount(RiskSlotReviewRecordDto dto);

    /**
     * 根据广告主名称,近多少天 查询广告主篡改数据
     */
    List<RiskSlotReviewRecordDto> getRecordByMaster(List<String> advertMasters, Integer days);
}
