package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import com.univocity.parsers.annotations.BooleanString;
import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.conversions.DateConversion;

import cn.com.duiba.tuia.risk.center.api.util.ReviewResultConversion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * tb_risk_dashboard_detail
 */
@ApiModel
public class RiskDashBoardDetailDto implements Serializable {
    /**
     * 主键
     */
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 当天日期
     */
    @ApiModelProperty("日期")
    @Parsed(field = "日期", defaultNullWrite = "")
    @Convert(conversionClass = DateConversion.class, args = "yyyy-MM-dd")
    private Date curDate;

    /**
     * 广告位ID
     */
    @ApiModelProperty("广告位ID")
    @Parsed(field = "广告位ID", defaultNullWrite = "")
    private Long slotId;

    /**
     * 广告位名称
     */
    @ApiModelProperty("广告位名称")
    @Parsed(field = "广告位名称", defaultNullWrite = "")
    private String slotName;

    /**
     * 媒体ID
     */
    @ApiModelProperty("媒体ID")
    @Parsed(field = "媒体ID", defaultNullWrite = "")
    private Long appId;

    /**
     * 媒体名字
     */
    @ApiModelProperty("媒体名称")
    @Parsed(field = "媒体名称", defaultNullWrite = "")
    private String appName;

    /**
     * 作弊消耗
     */
    @ApiModelProperty("作弊消耗")
    @Parsed(field = "作弊消耗", defaultNullWrite = "")
    private Long consume;

    /**
     * 命中用户数
     */
    @ApiModelProperty("命中用户数")
    @Parsed(field = "命中用户数", defaultNullWrite = "")
    private Long hitUserCount;

    /**
     * 风控处理方式 0-待处理,1-调分成,2-下线,3-暂不处理
     */
    @ApiModelProperty("风控处理方式 0-待处理,1-调分成,2-下线,3-暂不处理")
    @Parsed(field = "风控处理方式 ", defaultNullWrite = "", applyDefaultConversion = false)
    @Convert(conversionClass = ReviewResultConversion.class)
    private Integer processResult;

    /**
     * 风控处理次数=调分成+下线的次数之和
     */
    @ApiModelProperty("风控处理次数=调分成+下线的次数之和")
    @Parsed(field = "风控处理次数", defaultNullWrite = "")
    private Long processCount;

    /**
     * 命中的A规则
     */
    @ApiModelProperty("命中的A规则")
    @Parsed(field = "命中的A规则", defaultNullWrite = "")
    private String hitRules;

    /**
     * 命中的A规则的数量
     */
    @ApiModelProperty("命中的A规则的数量")
    private Integer hitRulesCount;

    /**
     * A规则风险分数
     */
    @ApiModelProperty("A规则风险分数")
    @Parsed(field = "A规则风险分数", defaultNullWrite = "")
    private Long aRiskScore;

    /**
     * 是否TOP30（按作弊消耗）：广告位当天按作弊消耗计算，是否在TOP30.  0-不是，1-是
     */
    @ApiModelProperty("是否TOP30（按作弊消耗）：广告位当天按作弊消耗计算，是否在TOP30.  0-不是，1-是")
    @Parsed(field = "是否TOP30（按作弊消耗）", defaultNullWrite = "")
    @BooleanString(trueStrings = {"是"}, falseStrings = {"否"})
    private Boolean isTop30;

    /**
     * 是否TOP30（按作弊消耗）：媒体当天按作弊消耗计算，是否在TOP30.  0-不是，1-是
     */
    @ApiModelProperty("是否TOP30（按作弊消耗）：媒体当天按作弊消耗计算，是否在TOP30.  0-不是，1-是")
    private Boolean isAppTop30;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date gmtModified;

    /**
     * tb_risk_dashboard_detail
     */
    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getConsume() {
        return consume;
    }

    public void setConsume(Long consume) {
        this.consume = consume;
    }

    public Long getHitUserCount() {
        return hitUserCount;
    }

    public void setHitUserCount(Long hitUserCount) {
        this.hitUserCount = hitUserCount;
    }

    public Integer getProcessResult() {
        return processResult;
    }

    public void setProcessResult(Integer processResult) {
        this.processResult = processResult;
    }

    public Long getProcessCount() {
        return processCount;
    }

    public void setProcessCount(Long processCount) {
        this.processCount = processCount;
    }

    public String getHitRules() {
        return hitRules;
    }

    public void setHitRules(String hitRules) {
        this.hitRules = hitRules;
    }

    public Integer getHitRulesCount() {
        return hitRulesCount;
    }

    public void setHitRulesCount(Integer hitRulesCount) {
        this.hitRulesCount = hitRulesCount;
    }

    public Long getaRiskScore() {
        return aRiskScore;
    }

    public void setaRiskScore(Long aRiskScore) {
        this.aRiskScore = aRiskScore;
    }

    public Boolean getTop30() {
        return isTop30;
    }

    public void setTop30(Boolean top30) {
        isTop30 = top30;
    }

    public Boolean getAppTop30() {
        return isAppTop30;
    }

    public void setAppTop30(Boolean appTop30) {
        isAppTop30 = appTop30;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public String toString() {
        return "RiskDashBoardDetailDto{" +
                "id=" + id +
                ", curDate=" + curDate +
                ", slotId=" + slotId +
                ", slotName='" + slotName + '\'' +
                ", appId=" + appId +
                ", appName='" + appName + '\'' +
                ", consume=" + consume +
                ", hitUserCount=" + hitUserCount +
                ", processResult=" + processResult +
                ", processCount=" + processCount +
                ", hitRules='" + hitRules + '\'' +
                ", hitRulesCount=" + hitRulesCount +
                ", aRiskScore=" + aRiskScore +
                ", isTop30=" + isTop30 +
                ", isAppTop30=" + isAppTop30 +
                ", gmtCreate=" + gmtCreate +
                ", gmtModified=" + gmtModified +
                '}';
    }
}