
package cn.com.duiba.tuia.risk.center.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.dto.KaSlotRecordDto;

import java.util.List;

/**
 * KA(重要)媒体广告位记录服务 ClassName: RemoteKaSlotRecordService <br/>
 * date: 2018年7月9日 下午6:45:20 <br/>
 * .
 *
 * @author lijian
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteKaSlotRecordService {

    /**
     * 根据媒体用户id(media_id)查询KA(重要)媒体广告位记录
     *
     * @param mediaIds
     * @return
     */
    List<KaSlotRecordDto> selectBymediaIds(List<Long> mediaIds);

    /**
     * 插入KA(重要)媒体广告位
     *
     * @param list
     * @return
     */
    Boolean saveByBatch(List<KaSlotRecordDto> list);

    /**
     * 删除KA(重要)媒体广告位记录
     *
     * @param dto
     * @return
     */
    Boolean deleteKaSlotRecord(KaSlotRecordDto dto);
}
