package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * 风控广告位导量表
 */
@ApiModel
public class SlotGuideListDto implements Serializable {

    private static final long serialVersionUID = 7571462055137639669L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("日期")
    private Date curDate;

    @ApiModelProperty("规则")
    private String ruleId;

    @ApiModelProperty("广告位ID")
    private Long slotId;

    @ApiModelProperty("广告位名称")
    private String slotName;

    @ApiModelProperty("媒体ID")
    private Long appId;

    @ApiModelProperty("媒体名称")
    private String appName;

    @ApiModelProperty("发券比例")
    private Double launchRate;

    @ApiModelProperty("广告位前一天的总发券量")
    private Long beforeLaunchPv;

    @ApiModelProperty("目标发券pv：命中规则对应的发券比例*该广告位前一天的发券量")
    private Long targetLaunchPv;

    @ApiModelProperty("已完成发券pv")
    private Long completedLaunchPv;

    @ApiModelProperty("目标完成率：已完成发券pv/目标发券pv")
    private Double targetCompleteRate;

    @ApiModelProperty("发券概率:目标发券pv/当天首次命中A规则的时间点，前一天该广告位该时间点之后的发券量")
    private Double launchChance;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return appName;
    }

    public void setLaunchRate(Double launchRate) {
        this.launchRate = launchRate;
    }

    public Double getLaunchRate() {
        return launchRate;
    }

    public void setBeforeLaunchPv(Long beforeLaunchPv) {
        this.beforeLaunchPv = beforeLaunchPv;
    }

    public Long getBeforeLaunchPv() {
        return beforeLaunchPv;
    }

    public void setTargetLaunchPv(Long targetLaunchPv) {
        this.targetLaunchPv = targetLaunchPv;
    }

    public Long getTargetLaunchPv() {
        return targetLaunchPv;
    }

    public void setCompletedLaunchPv(Long completedLaunchPv) {
        this.completedLaunchPv = completedLaunchPv;
    }

    public Long getCompletedLaunchPv() {
        return completedLaunchPv;
    }

    public void setTargetCompleteRate(Double targetCompleteRate) {
        this.targetCompleteRate = targetCompleteRate;
    }

    public Double getTargetCompleteRate() {
        return targetCompleteRate;
    }

    public void setLaunchChance(Double launchChance) {
        this.launchChance = launchChance;
    }

    public Double getLaunchChance() {
        return launchChance;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

