package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.EngineStrategyDto;

import java.util.Collection;
import java.util.List;

@AdvancedFeignClient
public interface RemoteEngineStrategyService {

    int insert(EngineStrategyDto strategy);

    int update(EngineStrategyDto strategy);

    int delete(long id);

    int deleteByKey(String key);

    int deleteBatchById(Collection<Long> ids);

    PageResultDto<EngineStrategyDto> query4Page(Long sceneId, int pageIndex, Integer pageSize);

    List<EngineStrategyDto> queryAll(Long sceneId);

    EngineStrategyDto getByName(String name);

    EngineStrategyDto getByKey(String key);

}
