package cn.com.duiba.tuia.risk.center.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel
public class BlacklistNewParam implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long nid;

    @NotNull(message = "风险等级不能为空")
    @Range(min = 0, max = 2, message = "风险等级参数值不在范围内")
    @ApiModelProperty("名单维度 0-低风险, 1-中风险, 2-高风险")
    private Integer riskRank;

    @NotNull(message = "名单维度不能为空")
    @Range(min = 0, max = 3, message = "名单维度参数值不在范围内")
    @ApiModelProperty("名单维度 0-ip, 1-device_id, 2-consumer_id")
    private Integer dimension;

    @NotNull(message = "名单值不能为空")
    @Length(max = 56, message = "名单值最大长度为56位")
    @ApiModelProperty("名单值")
    private String val;

    @NotNull(message = "状态不能为空")
    @Range(min = 0, max = 1, message = "状态参数值不在范围内")
    @ApiModelProperty("状态 0-启用 1-禁用")
    private Integer stat;

    @Length(max = 56, message = "来源最大长度为56位")
    @ApiModelProperty("来源")
    private String src;

    @Length(max = 64, message = "备注最大长度为64位")
    @ApiModelProperty("备注")
    private String memo;

    @ApiModelProperty("名单场景 0-推啊广告曝光场景 1-兑吧提现场景")
    @Range(min = 0, max = 10, message = "状态参数值不在范围内")
    private Integer scene;

    @ApiModelProperty("创建人")
    private String creator;

    public Integer getRiskRank() {
        return riskRank;
    }

    public void setRiskRank(Integer riskRank) {
        this.riskRank = riskRank;
    }

    public Integer getDimension() {
        return dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public String getVal() {
        return val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public String getSrc() {
        return src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public Integer getStat() {
        return stat;
    }

    public void setStat(Integer stat) {
        this.stat = stat;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Long getNid() {
        return nid;
    }

    public void setNid(Long nid) {
        this.nid = nid;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }
}
