package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.InterceptPatrolRecordDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.InterceptPatrolRecordParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteInterceptPatrolRecordService {

    @Deprecated
    int saveAndUpdate(InterceptPatrolRecordDto reviewDto);

    int update(InterceptPatrolRecordDto reviewDto);

    int insert(InterceptPatrolRecordDto reviewDto);

    /**
     * 根据条件分页查询广告落地页返回拦截日志
     *
     * @param params 时间范围，分页信息
     * @return 分页结果信息
     */
    PageResultDto<InterceptPatrolRecordDto> queryPage(InterceptPatrolRecordParam params);

    /*
    获取某个广告主的被拦截次数
     */
    int getAdvertMasterPatrolTimes(String advertMaster, String quarterBeginTime);

    List<InterceptPatrolRecordDto> getRecordByMaster(List<String> advertMasters, String quarterBeginTime);

    Integer updateById(InterceptPatrolRecordDto dto);

    /**
     * 根据广告id，是否申述成功  条件 查询最新的一条数据
     *
     * @param advertId
     * @param appealStatus
     * @return
     */
    InterceptPatrolRecordDto getLastRecordByParam(Long advertId, Integer appealStatus);
}
