package cn.com.duiba.tuia.risk.center.api.dto.domain;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 域名DTO
 *
 * @author peanut.huang
 * @date 2019/10/23
 * @since JDK 1.8
 */
@Data
@ToString
public class DomainDTO implements Serializable {

    private static final long serialVersionUID = 8977967840091677013L;

    /**
     * 域名记录id
     */
    private Long        id;

    /**
     * 域名地址
     */
    private String      domain;

    /**
     * 域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     */
    private Integer     domainType;

    /**
     * 域名状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainStatusEnum#status}
     */
    private Integer     domainStatus;

    /**
     * 域名在微信的投放状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainWXStatusEnum#status}
     */
    private Integer     wxStatus;

    /**
     * 添加人名称
     */
    private String      adminName;

    /**
     * 创建时间
     */
    private Date        gmtCreate;
}
