package cn.com.duiba.tuia.risk.center.api.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 媒体结算方式
 */
public enum SettlementMethod {
    FC(0, "分成"),
    CPC(1, "CPC"),
    CPM(2, "CPM"),
    UV(3, "UV单价"),
    CPT(4, "CPT");

    private Integer index;
    private String desc;

    private static Map<Integer, String> lookup = new HashMap<>();

    static {
        for (SettlementMethod sm : SettlementMethod.values()) {
            lookup.put(sm.getIndex(), sm.getDesc());
        }
    }

    public static String desc(Integer index) {
        return lookup.getOrDefault(index, "");
    }

    SettlementMethod(Integer index, String desc) {
        this.index = index;
        this.desc = desc;
    }

    public Integer getIndex() {
        return index;
    }

    public String getDesc() {
        return desc;
    }
}
