package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.tuia.risk.center.api.constant.RuleAction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则引擎规则日志表
 */
@ApiModel
public class EngineRuleLogDto implements Serializable {

    private static final long serialVersionUID = -4665665045326773382L;

    @ApiModelProperty("主键")
    private Long              id;

    @ApiModelProperty("场景ID")
    private Long              sceneId;

    @ApiModelProperty("策略id")
    private Long              strategyId;

    @ApiModelProperty("规则id")
    private Long              ruleId;

    @ApiModelProperty("父规则id")
    private Long              parentRuleId;

    @ApiModelProperty("规则名字")
    private String            ruleName;

    @ApiModelProperty("规则类型 (0=流程规则，1=评分规则）")
    private Integer           ruleType;

    @ApiModelProperty("模式（0=全部满足，1=任意满足）")
    private Integer           ruleMode;

    @ApiModelProperty("规则决策 （type=1时，为权重分）")
    private Double            decision;

    @ApiModelProperty("规则状态 （0=启用，1=试运行，2=禁用）")
    private Integer           ruleStatus;

    @ApiModelProperty("描述")
    private String            description;

    @ApiModelProperty("操作人")
    private String            operator;

    @ApiModelProperty("操作类型 （0=新建、1=编辑、2=变更状态、3=删除 ）")
    private Integer           operateType;

    @ApiModelProperty("规则后置行为")
    private RuleAction        ruleAction;

    @ApiModelProperty("拓展关联维度:1-rid,2-uuid6,3-deviceId,4-ua,5-ip")
    private Integer relateType;

    @ApiModelProperty("规则条件内容：json保存")
    private String            content;

    @ApiModelProperty("创建时间")
    private Date              gmtCreate;

    @ApiModelProperty("修改时间")
    private Date              gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public Long getParentRuleId() {
        return parentRuleId;
    }

    public void setParentRuleId(Long parentRuleId) {
        this.parentRuleId = parentRuleId;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public Integer getRuleMode() {
        return ruleMode;
    }

    public void setRuleMode(Integer ruleMode) {
        this.ruleMode = ruleMode;
    }

    public Double getDecision() {
        return decision;
    }

    public void setDecision(Double decision) {
        this.decision = decision;
    }

    public Integer getRuleStatus() {
        return ruleStatus;
    }

    public void setRuleStatus(Integer ruleStatus) {
        this.ruleStatus = ruleStatus;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Integer getOperateType() {
        return operateType;
    }

    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }

    public RuleAction getRuleAction() {
        return ruleAction;
    }

    public void setRuleAction(RuleAction ruleAction) {
        this.ruleAction = ruleAction;
    }

    public Integer getRelateType() {
        return relateType;
    }

    public void setRelateType(Integer relateType) {
        this.relateType = relateType;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
