package cn.com.duiba.tuia.risk.center.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 波动分析
 */
@ApiModel
public class ReqSlotWaveAnalysis implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("开始时间")
    @NotNull
    private String startDate;

    @ApiModelProperty("结束时间")
    @NotNull
    private String endDate;

    @ApiModelProperty("对比时间")
    @NotNull
    private String compareDate;

    @ApiModelProperty("广告位ID")
    private Long slotId;

    @ApiModelProperty("规则ID")
    private String ruleId;

    @ApiModelProperty("规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型，0-A类规则 1-C类规则-实时 2-C类规则离线")
    private Integer ruleType;

    @ApiModelProperty("媒体ID")
    private Long appId;

    @ApiModelProperty("排序字段")
    private String sortKey;

    @ApiModelProperty("排序方式：(升序:0,降序：1)默认降序")
    private Integer sortOrder;

    @ApiModelProperty("分页每页行数.")
    private Integer pageSize = 10;

    @ApiModelProperty("当前页码")
    private Integer currentPage = 1;

    private Integer from = 0;

    private Integer fetchSize;

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getSortKey() {
        return sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getFrom() {
        return from;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public Integer getFetchSize() {
        return fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public String getCompareDate() {
        return compareDate;
    }

    public void setCompareDate(String compareDate) {
        this.compareDate = compareDate;
    }

}
