package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 非标媒体监控表
 */
@ApiModel
public class RiskMediaMonitorDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("结算日期")
    private Date settleDate;

    @ApiModelProperty("上传日期")
    private Date uploadDate;

    @ApiModelProperty("广告位ID")
    private Long slotId;

    @ApiModelProperty("广告位名称")
    private String slotName;

    @ApiModelProperty("媒体id")
    private Long appId;

    @ApiModelProperty("媒体名称")
    private String appName;

    @ApiModelProperty("媒体运营")
    private String mediaOperate;

    @ApiModelProperty("今日结算方式:CPT/UV单价/CPC/CPM")
    private String todaySettleMethod;

    @ApiModelProperty("昨日结算方式:CPT/UV单价/CPC/CPM")
    private String yesSettleMethod;

    @ApiModelProperty("广告位消耗")
    private BigDecimal slotConsume;

    @ApiModelProperty("广告位作弊消耗")
    private BigDecimal cheatFee;

    @ApiModelProperty("作弊消耗占比")
    private BigDecimal cheatFeeRate;

    @ApiModelProperty("今日最终分成比例")
    private BigDecimal todayDivideRate;

    @ApiModelProperty("昨日最终分成比例")
    private BigDecimal yesDivideRate;

    @ApiModelProperty("媒体CPM")
    private BigDecimal mediaCpm;

    @ApiModelProperty("媒体CPC")
    private BigDecimal mediaCpc;

    @ApiModelProperty("媒体UV单价")
    private BigDecimal priceUv;

    @ApiModelProperty("广告位曝光PV")
    private Long slotExposePv;

    @ApiModelProperty("广告位点击PV")
    private Long slotClickPv;

    @ApiModelProperty("广告位访问PV")
    private Long slotVisitPv;

    @ApiModelProperty("参与率")
    private BigDecimal participateRate;

    @ApiModelProperty("广告位发券量")
    private Long launchPv;

    @ApiModelProperty("付费券占比")
    private BigDecimal payRate;

    @ApiModelProperty("媒体应得收入")
    private BigDecimal mediaIncome;

    @ApiModelProperty("监控规则")
    private String ruleName;

    @ApiModelProperty("复查内容")
    private String reviewResult;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setUploadDate(Date uploadDate) {
        this.uploadDate = uploadDate;
    }

    public Date getUploadDate() {
        return uploadDate;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return appName;
    }

    public void setMediaOperate(String mediaOperate) {
        this.mediaOperate = mediaOperate;
    }

    public String getMediaOperate() {
        return mediaOperate;
    }

    public void setTodaySettleMethod(String todaySettleMethod) {
        this.todaySettleMethod = todaySettleMethod;
    }

    public String getTodaySettleMethod() {
        return todaySettleMethod;
    }

    public void setYesSettleMethod(String yesSettleMethod) {
        this.yesSettleMethod = yesSettleMethod;
    }

    public String getYesSettleMethod() {
        return yesSettleMethod;
    }

    public void setSlotConsume(BigDecimal slotConsume) {
        this.slotConsume = slotConsume;
    }

    public BigDecimal getSlotConsume() {
        return slotConsume;
    }

    public void setCheatFee(BigDecimal cheatFee) {
        this.cheatFee = cheatFee;
    }

    public BigDecimal getCheatFee() {
        return cheatFee;
    }

    public void setCheatFeeRate(BigDecimal cheatFeeRate) {
        this.cheatFeeRate = cheatFeeRate;
    }

    public BigDecimal getCheatFeeRate() {
        return cheatFeeRate;
    }

    public void setTodayDivideRate(BigDecimal todayDivideRate) {
        this.todayDivideRate = todayDivideRate;
    }

    public BigDecimal getTodayDivideRate() {
        return todayDivideRate;
    }

    public void setYesDivideRate(BigDecimal yesDivideRate) {
        this.yesDivideRate = yesDivideRate;
    }

    public BigDecimal getYesDivideRate() {
        return yesDivideRate;
    }

    public void setMediaCpm(BigDecimal mediaCpm) {
        this.mediaCpm = mediaCpm;
    }

    public BigDecimal getMediaCpm() {
        return mediaCpm;
    }

    public void setMediaCpc(BigDecimal mediaCpc) {
        this.mediaCpc = mediaCpc;
    }

    public BigDecimal getMediaCpc() {
        return mediaCpc;
    }

    public void setPriceUv(BigDecimal priceUv) {
        this.priceUv = priceUv;
    }

    public BigDecimal getPriceUv() {
        return priceUv;
    }

    public void setSlotExposePv(Long slotExposePv) {
        this.slotExposePv = slotExposePv;
    }

    public Long getSlotExposePv() {
        return slotExposePv;
    }

    public void setSlotClickPv(Long slotClickPv) {
        this.slotClickPv = slotClickPv;
    }

    public Long getSlotClickPv() {
        return slotClickPv;
    }

    public void setSlotVisitPv(Long slotVisitPv) {
        this.slotVisitPv = slotVisitPv;
    }

    public Long getSlotVisitPv() {
        return slotVisitPv;
    }

    public void setParticipateRate(BigDecimal participateRate) {
        this.participateRate = participateRate;
    }

    public BigDecimal getParticipateRate() {
        return participateRate;
    }

    public void setLaunchPv(Long launchPv) {
        this.launchPv = launchPv;
    }

    public Long getLaunchPv() {
        return launchPv;
    }

    public void setPayRate(BigDecimal payRate) {
        this.payRate = payRate;
    }

    public BigDecimal getPayRate() {
        return payRate;
    }

    public void setMediaIncome(BigDecimal mediaIncome) {
        this.mediaIncome = mediaIncome;
    }

    public BigDecimal getMediaIncome() {
        return mediaIncome;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setReviewResult(String reviewResult) {
        this.reviewResult = reviewResult;
    }

    public String getReviewResult() {
        return reviewResult;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

