package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.RiskMaterialTagDto;
import cn.com.duiba.tuia.risk.center.api.dto.ViolationWordTagDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqPageQuery;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRiskMaterialTagService {

    Integer save(RiskMaterialTagDto dto);

    Integer deleteById(Long id);

    Integer updateById(RiskMaterialTagDto dto);

    /**
     * 根据标签标识查询标签数量
     * @param tagNum
     * @return
     */
    Integer getCountByTagNum(String tagNum);

    /**
     * 分页查询标签关键词数据
     * @param req
     * @return
     */
    PageResultDto<RiskMaterialTagDto> queryPage(ReqPageQuery req);

    List<RiskMaterialTagDto> getAllTag(ReqPageQuery req);

}
