package cn.com.duiba.tuia.risk.center.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 风控广告位导量表
 */
@ApiModel
public class ReqSlotGuideList implements Serializable {

    private static final long serialVersionUID = -2078645160113850358L;

    @ApiModelProperty("广告位ID")
    @NotNull(message = "广告位id不能为空")
    private Long slotId;

    @ApiModelProperty("目标发券pv：命中规则对应的发券比例*该广告位前一天的发券量")
    @NotNull(message = "目标发券pv不能为空")
    private Long targetLaunchPv;

    @ApiModelProperty("发券概率:目标发券pv/当天首次命中A规则的时间点，前一天该广告位该时间点之后的发券量")
    @NotNull(message = "发券概率不能为空")
    private Double launchChance;

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getTargetLaunchPv() {
        return targetLaunchPv;
    }

    public void setTargetLaunchPv(Long targetLaunchPv) {
        this.targetLaunchPv = targetLaunchPv;
    }

    public Double getLaunchChance() {
        return launchChance;
    }

    public void setLaunchChance(Double launchChance) {
        this.launchChance = launchChance;
    }
}

