package cn.com.duiba.tuia.risk.center.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel
public class SlotStatisticParam {

    @ApiModelProperty("开始时间 yyyy-MM-dd")
    private String startTime;
    @ApiModelProperty("结束时间 yyyy-MM-dd")
    private String endTime;
    @ApiModelProperty("广告位id")
    private Long slotId;
    @ApiModelProperty("媒体id")
    private Long appId;
    @ApiModelProperty("维度：0-ip、1-device、2-ua、3-city、4-设备品牌、5-浏览器、6-操作系统版本、7-网络类型")
    private Integer dimension;
    @ApiModelProperty("IP、device_id、UserAgent、city、设备品牌、浏览器、操作系统版本、网络类型")
    private String metric;
    @ApiModelProperty("排除的值")
    private List<String> excludeMetrics;
    @ApiModelProperty("广告位发券量")
    private Long slotLaunchCount;
    @ApiModelProperty("排序字段")
    private String sortKey;
    @ApiModelProperty("排列顺序： 0 升序  1 降序")
    private Integer sortOrder;
    @ApiModelProperty("当前页码")
    private Integer pageIndex;
    @ApiModelProperty("每页条数")
    private Integer pageSize = 10;

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getDimension() {
        return dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public String getMetric() {
        return metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public List<String> getExcludeMetrics() {
        return excludeMetrics;
    }

    public void setExcludeMetrics(List<String> excludeMetrics) {
        this.excludeMetrics = excludeMetrics;
    }

    public Long getSlotLaunchCount() {
        return slotLaunchCount;
    }

    public void setSlotLaunchCount(Long slotLaunchCount) {
        this.slotLaunchCount = slotLaunchCount;
    }

    public String getSortKey() {
        return sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }
}
