package cn.com.duiba.tuia.risk.center.api.enums;

public enum MediaSlotWhiteSeneceEnum {

    RISK_CHECK(0,"作弊验证场景"),
    RISK_SYNC(1,"作弊媒体钟馗同步场景"),
    RISK_INTERCEPT(2,"作弊流量实时拦截场景"),
    RISK_A16(3,"A16"),
    RISK_C18(4,"C18"),
    RISK_C21(5,"C21"),
    RISK_C16_1(6,"C16-1"),
    RISK_C29_1(7,"C29-1"),
    UNKNOWN(-1,"未知");

    private Integer code;

    private String  desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    MediaSlotWhiteSeneceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static MediaSlotWhiteSeneceEnum getEnumeByCode(Integer code){

        for (MediaSlotWhiteSeneceEnum value : MediaSlotWhiteSeneceEnum.values()) {

            if(value.getCode().equals(code)){
                return value;
            }
        }

        return UNKNOWN;
    }
}
