package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 最全宽表dto
 *
 * @author chengdeman
 * @create 2018-02-27 下午5:34
 **/
@ApiModel
public class DwsSlotRiskAllDIDto implements Serializable {

    private static final long serialVersionUID = 6127783306898742149L;
    /**
     * 主键ID
     */
    private Long              id;

    /**
     * 日期
     */
    private String            curDate;

    /**
     * 异常时间点
     */
    private String            dHour;

    /**
     * 广告位ID
     */
    private Long              slotId;

    /**
     * 广告位名称
     */
    private String            slotName;

    /**
     * APPid
     */
    private Long              appId;

    /**
     * APP名称
     */
    private String            appName;

    /**
     * 广告位曝光PV
     */
    private Long              actExposeCount;

    /**
     * 广告位点击PV
     */
    private Long              actClickCount;
    /**
     * 广告位点击率=广告位点击PV/广告位曝光PV
     */
    private Double            actClickRate;
    /**
     * 广告位访问PV
     */
    private Long              sdkPv;
    /**
     * 广告位访问UV
     */
    private Long              sdkUv;
    /**
     * 活动访问（请求）PV
     */
    private Long              actRequestPv;
    /**
     * 活动访问（请求）UV
     */
    private Long              actRequestUv;
    /**
     * 活动参与PV
     */
    private Long              participatePv;
    /**
     * 活动参与uV
     */
    private Long              participateUv;
    /**
     * 参与率
     */
    private Double            participateRate;
    /**
     * 复参数
     */
    private Double            dupliParticipate;
    /**
     * 广告发券量
     */
    private Long              launchPv;
    /**
     * 每uv发券=发券量/广告位访问UV
     */
    private Double            eachLaunchUv;
    /**
     * 券曝光量
     */
    private Long              advertExposePv;
    /**
     * 券普通点击量
     */
    private Long              advertClickPv;
    /**
     * 券计费点击量
     */
    private Long              advertVclickPv;
    /**
     * 券点击率=券点击PV/广告曝光PV
     */
    private Double            advertClickRate;
    /**
     * 券计费点击率=券计费点击PV/广告曝光P
     */
    private Double            advertVclickRate;
    /**
     * 每uv券普通点击=广告点击PV/广告点击UV
     */
    private Double            eachClickUv;
    /**
     * 广告消耗
     */
    @ApiModelProperty("广告位消耗")
    private Long              adConsume;
    /**
     * 作弊消耗
     */
    private Double            cheatFee;
    /**
     * 作弊消耗占比=作弊消耗/消耗
     */
    private Double            cheatFeeRate;
    /**
     * js广告普通点击pv
     */
    private Long              jsClickPv;
    /**
     * 落地页访问pv
     */
    private Long              visitPv;
    /**
     * 落地页访问uv
     */
    private Long              visitUv;
    /**
     * 落地页效果（转化）pv'
     */
    private Long              effectPv;
    /**
     * 落地页效果（转化）uv
     */
    private Long              effectUv;
    /**
     * 落地页转化率CVR=落地页转化PV/落地页访问PV
     */
    private Double            cvr;
    /**
     * 落地页理论转化率=(广告1落地页访问pv*广告1当日CVR+...+广告n落地页访问pv*广告n当日平台CVR)/(广告1落地页访问pv+...+广告n落地页访问pv)
     */
    private Double            estiCvr;
    /**
     * 媒体应得分成(分)'
     */
    private Long              mediaDueDivide;
    /**
     * 分成比例=媒体应得分成/广告消耗
     */
    @ApiModelProperty("分成比例")
    private Double            divideRate;
    /**
     * 建议分成比例=(媒体应得分成/广告消耗)*(媒体消耗-作弊消耗)/媒体消耗
     */
    private Double            adviseDivideRate;
    /**
     * 媒体CPM=媒体应得分成*1000/广告位曝光PV
     */
    private Double            CPM;
    /**
     * 媒体UV单价=媒体应得分成／广告位访问UV(分)
     */
    private Double            priceUv;
    /**
     * arpu=消耗/发券量(分)
     */
    private Double            arpu;
    /**
     * 综合信用分=命中广告位策略权重分加和+作弊消耗比例*5
     */
    private Double            creditsScore;
    /**
     * 点击率皮尔逊相关系数
     */
    private Double            corrClick;
    /**
     * 点击率标准差
     */
    private Double            stddevClick;
    /**
     * 转化率皮尔逊相关系数
     */
    private Double            corrCvr;
    /**
     * 点击率皮尔逊相关系数
     */
    private Double            stddevCvr;
    /**
     * 命中策略
     */
    private String            rules;
    /**
     * 媒体运营
     */
    private String            mediaName;
    /**
     * '媒介运营'
     */
    private String            agentName;
    /**
     * 媒体当日消耗
     */
    private Long              appAdConsume;
    /**
     * 作弊等级
     */
    private String            cheatGrade;

    /* ======== 风控审核关联表字段 ====== start */

    /**
     * 风控审核表主键ID
     */
    private Long              riskReviewId;

    /**
     * 初步审核人
     */
    private String            preRiskReviewer;

    /**
     * 初步处理结果
     */
    private Integer           preResult;

    /**
     * 初步处理时间
     */
    private String            preResultTime;

    /**
     * 是否需要上级审核
     */
    private Integer           isSuperiorReview;

    /**
     * 最终审核结果
     */
    private Integer           reviewResult;

    /**
     * 最终审核时间
     */
    private String            reviewResultTime;

    /**
     * 最终审核人，如果不用上报上级就是初级审核人
     */
    private String            riskReviewer;

    /**
     * 是否进入案例库;0:否；1：是
     */
    private Integer           isInExample;

    /**
     * 审核备注
     */
    private String            reviewRemarks;

    // 当前处理进度
    private String            currentProgress  = "待处理";

    /**
     * 媒体处理意见：1 同意 0 拒绝
     */
    private Integer           mediaDealOpinion;

    /**
     * 最终处理金额
     */
    private Double            finalDealMoney;

    /* ======== 风控审核关联表字段 ====== end */

    /* ======== 风控案例库关联表字段 ====== start */

    /**
     * 案例库ID
     */
    private Long              exampleId;

    /**
     * 累计处理次数
     */
    private Long              reviewCount      = 0L;

    /**
     * 案例特征
     */
    private String            exampleFeatures;

    /**
     * 案例需求
     */
    private String            exampleDemand;

    /**
     * 案例结果
     */
    private String            exampleResult;

    private List<String>      imgs;

    /* ======== 风控案例库关联表字段 ====== end */

    private String            gmtCreate;

    private Integer           exampleStatus;

    private Integer           countOfImgs;

    private Boolean           needNotify;

    /**
     * 媒体反馈备注
     */
    private String            mediaMemo;

    /**
     * 原分成比例
     */
    private Integer           originRate;

    /**
     * 建议分成比例
     */
    private Integer           adviceRate;

    /**
     * 媒体反馈的分成比例
     */
    private Integer           finalRate;

    /**
     * 结算方式
     */
    private Integer settleMethod;

    public Integer getExampleStatus() {
        return exampleStatus;
    }

    public void setExampleStatus(Integer exampleStatus) {
        this.exampleStatus = exampleStatus;
    }

    public String getdHour() {
        return dHour;
    }

    public void setdHour(String dHour) {
        this.dHour = dHour;
    }

    public String getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCurDate() {
        return curDate;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getActExposeCount() {
        return actExposeCount;
    }

    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }

    public Long getActClickCount() {
        return actClickCount;
    }

    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }

    public Double getActClickRate() {
        return actClickRate;
    }

    public void setActClickRate(Double actClickRate) {
        this.actClickRate = actClickRate;
    }

    public Long getSdkPv() {
        return sdkPv;
    }

    public void setSdkPv(Long sdkPv) {
        this.sdkPv = sdkPv;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getActRequestPv() {
        return actRequestPv;
    }

    public void setActRequestPv(Long actRequestPv) {
        this.actRequestPv = actRequestPv;
    }

    public Long getActRequestUv() {
        return actRequestUv;
    }

    public void setActRequestUv(Long actRequestUv) {
        this.actRequestUv = actRequestUv;
    }

    public Long getParticipatePv() {
        return participatePv;
    }

    public void setParticipatePv(Long participatePv) {
        this.participatePv = participatePv;
    }

    public Long getParticipateUv() {
        return participateUv;
    }

    public void setParticipateUv(Long participateUv) {
        this.participateUv = participateUv;
    }

    public Double getParticipateRate() {
        return participateRate;
    }

    public void setParticipateRate(Double participateRate) {
        this.participateRate = participateRate;
    }

    public Double getDupliParticipate() {
        return dupliParticipate;
    }

    public void setDupliParticipate(Double dupliParticipate) {
        this.dupliParticipate = dupliParticipate;
    }

    public Long getLaunchPv() {
        return launchPv;
    }

    public void setLaunchPv(Long launchPv) {
        this.launchPv = launchPv;
    }

    public Double getEachLaunchUv() {
        return eachLaunchUv;
    }

    public void setEachLaunchUv(Double eachLaunchUv) {
        this.eachLaunchUv = eachLaunchUv;
    }

    public Long getAdvertExposePv() {
        return advertExposePv;
    }

    public void setAdvertExposePv(Long advertExposePv) {
        this.advertExposePv = advertExposePv;
    }

    public Long getAdvertClickPv() {
        return advertClickPv;
    }

    public void setAdvertClickPv(Long advertClickPv) {
        this.advertClickPv = advertClickPv;
    }

    public Long getAdvertVclickPv() {
        return advertVclickPv;
    }

    public void setAdvertVclickPv(Long advertVclickPv) {
        this.advertVclickPv = advertVclickPv;
    }

    public Double getAdvertClickRate() {
        return advertClickRate;
    }

    public void setAdvertClickRate(Double advertClickRate) {
        this.advertClickRate = advertClickRate;
    }

    public Double getAdvertVclickRate() {
        return advertVclickRate;
    }

    public void setAdvertVclickRate(Double advertVclickRate) {
        this.advertVclickRate = advertVclickRate;
    }

    public Double getEachClickUv() {
        return eachClickUv;
    }

    public void setEachClickUv(Double eachClickUv) {
        this.eachClickUv = eachClickUv;
    }

    public Long getAdConsume() {
        return adConsume;
    }

    public void setAdConsume(Long adConsume) {
        this.adConsume = adConsume;
    }

    public Double getCheatFee() {
        return cheatFee;
    }

    public void setCheatFee(Double cheatFee) {
        this.cheatFee = cheatFee;
    }

    public Double getCheatFeeRate() {
        return cheatFeeRate;
    }

    public void setCheatFeeRate(Double cheatFeeRate) {
        this.cheatFeeRate = cheatFeeRate;
    }

    public Long getJsClickPv() {
        return jsClickPv;
    }

    public void setJsClickPv(Long jsClickPv) {
        this.jsClickPv = jsClickPv;
    }

    public Long getVisitPv() {
        return visitPv;
    }

    public void setVisitPv(Long visitPv) {
        this.visitPv = visitPv;
    }

    public Long getVisitUv() {
        return visitUv;
    }

    public void setVisitUv(Long visitUv) {
        this.visitUv = visitUv;
    }

    public Long getEffectPv() {
        return effectPv;
    }

    public void setEffectPv(Long effectPv) {
        this.effectPv = effectPv;
    }

    public Long getEffectUv() {
        return effectUv;
    }

    public void setEffectUv(Long effectUv) {
        this.effectUv = effectUv;
    }

    public Double getCvr() {
        return cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public Double getEstiCvr() {
        return estiCvr;
    }

    public void setEstiCvr(Double estiCvr) {
        this.estiCvr = estiCvr;
    }

    public Long getMediaDueDivide() {
        return mediaDueDivide;
    }

    public void setMediaDueDivide(Long mediaDueDivide) {
        this.mediaDueDivide = mediaDueDivide;
    }

    public Double getDivideRate() {
        return divideRate;
    }

    public void setDivideRate(Double divideRate) {
        this.divideRate = divideRate;
    }

    public Double getAdviseDivideRate() {
        return adviseDivideRate;
    }

    public void setAdviseDivideRate(Double adviseDivideRate) {
        this.adviseDivideRate = adviseDivideRate;
    }

    public Double getCPM() {
        return CPM;
    }

    public void setCPM(Double CPM) {
        this.CPM = CPM;
    }

    public Double getPriceUv() {
        return priceUv;
    }

    public void setPriceUv(Double priceUv) {
        this.priceUv = priceUv;
    }

    public Double getArpu() {
        return arpu;
    }

    public void setArpu(Double arpu) {
        this.arpu = arpu;
    }

    public Double getCreditsScore() {
        return creditsScore;
    }

    public void setCreditsScore(Double creditsScore) {
        this.creditsScore = creditsScore;
    }

    public Double getCorrClick() {
        return corrClick;
    }

    public void setCorrClick(Double corrClick) {
        this.corrClick = corrClick;
    }

    public Double getStddevClick() {
        return stddevClick;
    }

    public void setStddevClick(Double stddevClick) {
        this.stddevClick = stddevClick;
    }

    public Double getCorrCvr() {
        return corrCvr;
    }

    public void setCorrCvr(Double corrCvr) {
        this.corrCvr = corrCvr;
    }

    public Double getStddevCvr() {
        return stddevCvr;
    }

    public void setStddevCvr(Double stddevCvr) {
        this.stddevCvr = stddevCvr;
    }

    public String getRules() {
        return rules;
    }

    public void setRules(String rules) {
        this.rules = rules;
    }

    public String getMediaName() {
        return mediaName;
    }

    public void setMediaName(String mediaName) {
        this.mediaName = mediaName;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Long getAppAdConsume() {
        return appAdConsume;
    }

    public void setAppAdConsume(Long appAdConsume) {
        this.appAdConsume = appAdConsume;
    }

    public String getCheatGrade() {
        return cheatGrade;
    }

    public void setCheatGrade(String cheatGrade) {
        this.cheatGrade = cheatGrade;
    }

    public Long getRiskReviewId() {
        return riskReviewId;
    }

    public void setRiskReviewId(Long riskReviewId) {
        this.riskReviewId = riskReviewId;
    }

    public String getPreRiskReviewer() {
        return preRiskReviewer;
    }

    public void setPreRiskReviewer(String preRiskReviewer) {
        this.preRiskReviewer = preRiskReviewer;
    }

    public Integer getPreResult() {
        return preResult;
    }

    public void setPreResult(Integer preResult) {
        this.preResult = preResult;
    }

    public String getPreResultTime() {
        return preResultTime;
    }

    public void setPreResultTime(String preResultTime) {
        this.preResultTime = preResultTime;
    }

    public Integer getIsSuperiorReview() {
        return isSuperiorReview;
    }

    public void setIsSuperiorReview(Integer isSuperiorReview) {
        this.isSuperiorReview = isSuperiorReview;
    }

    public Integer getReviewResult() {
        return reviewResult;
    }

    public void setReviewResult(Integer reviewResult) {
        this.reviewResult = reviewResult;
    }

    public String getReviewResultTime() {
        return reviewResultTime;
    }

    public void setReviewResultTime(String reviewResultTime) {
        this.reviewResultTime = reviewResultTime;
    }

    public String getRiskReviewer() {
        return riskReviewer;
    }

    public void setRiskReviewer(String riskReviewer) {
        this.riskReviewer = riskReviewer;
    }

    public Integer getIsInExample() {
        return isInExample;
    }

    public void setIsInExample(Integer isInExample) {
        this.isInExample = isInExample;
    }

    public String getReviewRemarks() {
        return reviewRemarks;
    }

    public void setReviewRemarks(String reviewRemarks) {
        this.reviewRemarks = reviewRemarks;
    }

    public Long getExampleId() {
        return exampleId;
    }

    public void setExampleId(Long exampleId) {
        this.exampleId = exampleId;
    }

    public Long getReviewCount() {
        return reviewCount;
    }

    public void setReviewCount(Long reviewCount) {
        this.reviewCount = reviewCount;
    }

    public String getExampleFeatures() {
        return exampleFeatures;
    }

    public void setExampleFeatures(String exampleFeatures) {
        this.exampleFeatures = exampleFeatures;
    }

    public String getExampleDemand() {
        return exampleDemand;
    }

    public void setExampleDemand(String exampleDemand) {
        this.exampleDemand = exampleDemand;
    }

    public String getExampleResult() {
        return exampleResult;
    }

    public void setExampleResult(String exampleResult) {
        this.exampleResult = exampleResult;
    }

    public String getCurrentProgress() {
        return currentProgress;
    }

    public void setCurrentProgress(String currentProgress) {
        this.currentProgress = currentProgress;
    }

    public Integer getCountOfImgs() {
        return countOfImgs;
    }

    public void setCountOfImgs(Integer countOfImgs) {
        this.countOfImgs = countOfImgs;
    }

    public Boolean getNeedNotify() {
        return needNotify;
    }

    public void setNeedNotify(Boolean needNotify) {
        this.needNotify = needNotify;
    }

    public List<String> getImgs() {
        return imgs;
    }

    public void setImgs(List<String> imgs) {
        this.imgs = imgs;
    }

    public Integer getMediaDealOpinion() {
        return mediaDealOpinion;
    }

    public void setMediaDealOpinion(Integer mediaDealOpinion) {
        this.mediaDealOpinion = mediaDealOpinion;
    }

    public Double getFinalDealMoney() {
        return finalDealMoney;
    }

    public void setFinalDealMoney(Double finalDealMoney) {
        this.finalDealMoney = finalDealMoney;
    }

    public String getMediaMemo() {
        return mediaMemo;
    }

    public void setMediaMemo(String mediaMemo) {
        this.mediaMemo = mediaMemo;
    }

    public Integer getOriginRate() {
        return originRate;
    }

    public void setOriginRate(Integer originRate) {
        this.originRate = originRate;
    }

    public Integer getAdviceRate() {
        return adviceRate;
    }

    public void setAdviceRate(Integer adviceRate) {
        this.adviceRate = adviceRate;
    }

    public Integer getFinalRate() {
        return finalRate;
    }

    public void setFinalRate(Integer finalRate) {
        this.finalRate = finalRate;
    }

    public Integer getSettleMethod() {
        return settleMethod;
    }

    public void setSettleMethod(Integer settleMethod) {
        this.settleMethod = settleMethod;
    }
}
