package cn.com.duiba.tuia.risk.center.api.dto;

import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.conversions.DateConversion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel
public class InterceptPatrolRecordDto implements Serializable {

    private static final long serialVersionUID = -240957152897467396L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("广告计划id")
    @Parsed(field = "广告计划id", defaultNullWrite = "")
    private Long advertId;

    @ApiModelProperty("广告名称")
    @Parsed(field = "广告计划名称", defaultNullWrite = "")
    private String advertName;

    @ApiModelProperty("广告主名称")
    @Parsed(field = "广告主名称", defaultNullWrite = "")
    private String advertMaster;

    @ApiModelProperty("广告主返回拦截次数")
    @Parsed(field = "广告主返回拦截次数", defaultNullWrite = "")
    private Integer interceptCount;

    @ApiModelProperty("AE名称")
    @Parsed(field = "AE", defaultNullWrite = "")
    private String aeName;

    @ApiModelProperty("销售名称")
    @Parsed(field = "销售", defaultNullWrite = "")
    private String saleName;

    @ApiModelProperty("巡查时间")
    @Parsed(field = "下线时间", defaultNullWrite = "")
    @Convert(conversionClass = DateConversion.class, args = "yyyy-MM-dd HH:mm:ss")
    private Date patrolTime;

    @ApiModelProperty("落地页链接")
    @Parsed(field = "落地页链接", defaultNullWrite = "")
    private String url;

    @ApiModelProperty("是否存在返回拦截 0-否，1-是")
    private Integer interceptStatus;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("视频证明url")
    private String videoUrl;

    @ApiModelProperty("申诉状态：0-未申诉、1-申诉成功、2-申诉失败")
    private Integer appealStatus;

    //当前季度开始时间
    private String quarterBeginTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Date getPatrolTime() {
        return patrolTime;
    }

    public void setPatrolTime(Date patrolTime) {
        this.patrolTime = patrolTime;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public String getAdvertMaster() {
        return advertMaster;
    }

    public void setAdvertMaster(String advertMaster) {
        this.advertMaster = advertMaster;
    }

    public Integer getInterceptCount() {
        return interceptCount;
    }

    public void setInterceptCount(Integer interceptCount) {
        this.interceptCount = interceptCount;
    }

    public String getAeName() {
        return aeName;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public String getSaleName() {
        return saleName;
    }

    public void setSaleName(String saleName) {
        this.saleName = saleName;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getInterceptStatus() {
        return interceptStatus;
    }

    public void setInterceptStatus(Integer interceptStatus) {
        this.interceptStatus = interceptStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public Integer getAppealStatus() {
        return appealStatus;
    }

    public void setAppealStatus(Integer appealStatus) {
        this.appealStatus = appealStatus;
    }

    public String getQuarterBeginTime() {
        return quarterBeginTime;
    }

    public void setQuarterBeginTime(String quarterBeginTime) {
        this.quarterBeginTime = quarterBeginTime;
    }
}
